/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.mrmr;

import com.rapidminer.example.Example;
import com.rapidminer.operator.performance.MeasuredPerformance;
import com.rapidminer.tools.math.Averagable;

public class MIDCriterion
extends MeasuredPerformance {
    private static final long serialVersionUID = -5343958353990535895L;
    protected double mid = 0.0;
    protected double counter = 1.0;

    public MIDCriterion() {
    }

    public MIDCriterion(double rel, double red) {
        this.mid = rel - red;
    }

    public MIDCriterion(double rel, double red, double alpha) {
        this.mid = alpha * rel - (1.0 - alpha) * red;
    }

    public MIDCriterion(MIDCriterion rc) {
        super((MeasuredPerformance)rc);
        this.mid = rc.mid;
        this.counter = rc.counter;
    }

    public String getName() {
        return "mutual_information_difference";
    }

    public String getDescription() {
        return "Relevance - alpha * Redundancy";
    }

    public double getComparisonCount() {
        return this.counter;
    }

    public double getExampleCount() {
        return this.counter;
    }

    public void countExample(Example example) {
    }

    public double getFitness() {
        return this.mid;
    }

    public double getMikroAverage() {
        return this.mid;
    }

    public double getMikroVariance() {
        return Double.NaN;
    }

    public void buildSingleAverage(Averagable averagable) {
        try {
            MIDCriterion other = (MIDCriterion)averagable;
            this.mid += other.mid;
            this.counter += other.counter;
        }
        catch (Exception e) {
            this.log("Could not build average because of casting error.");
        }
    }
}

