/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.mfs;

import com.rapidminer.example.AttributeWeights;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.mfs.AbstractWeightingChain;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeString;
import java.util.ConcurrentModificationException;
import java.util.List;

public class Selection2Ranking
extends AbstractWeightingChain {
    public static final String PARAMETER_K = "k";
    public static final String PARAMETER_NORMALIZE = "normalize_weights";
    public static final String PARAMETER_NAME_OF_K_PARAM = "name_of_k_param";
    private int iteration = 0;

    public Selection2Ranking(OperatorDescription description) {
        super(description);
    }

    @Override
    public void doWork() throws OperatorException {
        this.iteration = 0;
        ExampleSet inputSet = (ExampleSet)this.exampleSetInput.getData();
        AttributeWeights resWeights = new AttributeWeights(inputSet);
        String[] attributeNames = new String[resWeights.getAttributeNames().size()];
        attributeNames = resWeights.getAttributeNames().toArray(attributeNames);
        String nameOfKParam = this.getParameterAsString(PARAMETER_NAME_OF_K_PARAM);
        String[] target = nameOfKParam.split("\\.");
        if (target.length != 2) {
            throw new UserError((Operator)this, 907, new Object[]{nameOfKParam});
        }
        Operator operator = this.getProcess().getOperator(target[0]);
        if (operator == null) {
            throw new UserError((Operator)this, 109, new Object[]{target[0]});
        }
        for (int j = 0; j < attributeNames.length; ++j) {
            resWeights.setWeight(attributeNames[j], 0.0);
        }
        int k = this.getParameterAsInt(PARAMETER_K);
        if (k <= 1) {
            k = inputSet.size();
        }
        this.iteration = 1;
        while (this.iteration <= k) {
            operator.setParameter(target[1], String.valueOf(this.iteration));
            try {
                this.weightingProcessExampleSetOutput.deliver((IOObject)inputSet);
                this.getSubprocess(0).execute();
            }
            catch (ConcurrentModificationException e) {
                if (this.isDebugMode()) {
                    e.printStackTrace();
                }
                throw new UserError((Operator)this, 923);
            }
            AttributeWeights weights = (AttributeWeights)this.weightingProcessWeightsInput.getData();
            for (String att : weights.getAttributeNames()) {
                if (!(weights.getWeight(att) > 0.0)) continue;
                resWeights.setWeight(att, resWeights.getWeight(att) + 1.0);
            }
            this.inApplyLoop();
            ++this.iteration;
        }
        resWeights.sortByWeight(attributeNames, -1, 0);
        for (int i = 0; i < attributeNames.length; ++i) {
            if (resWeights.getWeight(attributeNames[i]) == 0.0) {
                resWeights.setWeight(attributeNames[i], Double.POSITIVE_INFINITY);
                continue;
            }
            resWeights.setWeight(attributeNames[i], (double)(i + 1));
        }
        this.weightsOutput.deliver((IOObject)resWeights);
        this.exampleSetOutput.deliver((IOObject)inputSet);
    }

    public List<ParameterType> getParameterTypes() {
        List types = super.getParameterTypes();
        ParameterTypeInt type = new ParameterTypeInt(PARAMETER_K, "Parameter k, as in top-k", 0, Integer.MAX_VALUE, 100);
        types.add(type);
        type = new ParameterTypeString(PARAMETER_NAME_OF_K_PARAM, "Name of the k parameter of the inner operator", "SomeOperator.k");
        types.add(type);
        return types;
    }
}

