/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.mfs;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeWeights;
import com.rapidminer.example.Attributes;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.OperatorCapability;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.features.weighting.AbstractWeighting;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeDouble;
import java.util.List;

public class SAMWeighting
extends AbstractWeighting {
    public static final String PARAMETER_S0 = "s0";

    public SAMWeighting(OperatorDescription description) {
        super(description);
    }

    public AttributeWeights calculateWeights(ExampleSet exampleSet) throws OperatorException {
        int p = exampleSet.getAttributes().size();
        int n = exampleSet.getExampleTable().size();
        if (n <= 2) {
            throw new OperatorException("The example set needs at least 3 examples.");
        }
        int n1 = 0;
        int n2 = 0;
        double s0 = this.getParameterAsDouble(PARAMETER_S0);
        double[] X1 = new double[p];
        double[] X2 = new double[p];
        double[] XX1 = new double[p];
        double[] XX2 = new double[p];
        int i = 0;
        double val = 0.0;
        Attributes attributes = exampleSet.getAttributes();
        for (Example example : exampleSet) {
            i = 0;
            if (example.getLabel() == 0.0) {
                for (Attribute attribute : attributes) {
                    val = example.getValue(attribute);
                    int n3 = i;
                    X1[n3] = X1[n3] + val;
                    int n4 = i++;
                    XX1[n4] = XX1[n4] + val * val;
                }
                ++n1;
                continue;
            }
            for (Attribute attribute : attributes) {
                val = example.getValue(attribute);
                int n5 = i;
                X2[n5] = X2[n5] + val;
                int n6 = i++;
                XX2[n6] = XX2[n6] + val * val;
            }
            ++n2;
        }
        AttributeWeights weights = new AttributeWeights(exampleSet);
        double a = (1.0 / (double)n1 + 1.0 / (double)n2) / (double)(n1 + n2 - 2);
        i = 0;
        for (Attribute attribute : exampleSet.getAttributes()) {
            double x1 = X1[i];
            double xx1 = XX1[i];
            double x2 = X2[i];
            double xx2 = XX2[i];
            weights.setWeight(attribute.getName(), Math.abs(x1 / (double)n1 - x2 / (double)n2) / (Math.sqrt(a * (xx1 - x1 * x1 / (double)n1 + (xx2 - x2 * x2 / (double)n2))) + s0));
            ++i;
        }
        return weights;
    }

    public List<ParameterType> getParameterTypes() {
        List list = super.getParameterTypes();
        list.add(new ParameterTypeDouble(PARAMETER_S0, "Small constant to cope with variance in low expression", 0.0, Double.MAX_VALUE, 0.1));
        return list;
    }

    public boolean supportsCapability(OperatorCapability capability) {
        if (capability == OperatorCapability.BINOMINAL_LABEL || capability == OperatorCapability.NUMERICAL_ATTRIBUTES) {
            return true;
        }
        return capability != OperatorCapability.NUMERICAL_LABEL && capability != OperatorCapability.BINOMINAL_ATTRIBUTES && capability != OperatorCapability.POLYNOMINAL_LABEL && capability != OperatorCapability.POLYNOMINAL_ATTRIBUTES;
    }
}

