/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.mfs;

import com.rapidminer.example.AttributeWeights;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.parameter.ParameterType;
import java.util.List;

public class RemoveZeroWeights
extends Operator {
    private final InputPort weightsInput = this.getInputPorts().createPort("weights", AttributeWeights.class);
    private final OutputPort weightsOutput = (OutputPort)this.getOutputPorts().createPort("weights");

    public RemoveZeroWeights(OperatorDescription description) {
        super(description);
    }

    public void doWork() throws OperatorException {
        AttributeWeights weights = (AttributeWeights)this.weightsInput.getData();
        String[] attributeNames = new String[weights.getAttributeNames().size()];
        for (String att : attributeNames = weights.getAttributeNames().toArray(attributeNames)) {
            if (weights.getWeight(att) != 0.0) continue;
            weights.removeAttributeWeight(att);
        }
        this.weightsOutput.deliver((IOObject)weights);
    }

    public List<ParameterType> getParameterTypes() {
        List types = super.getParameterTypes();
        return types;
    }
}

