/*
 * Decompiled with CFR 0.152.
 */
package timeseriesclustering.experiments;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import timeseriesclustering.DTW;
import timeseriesclustering.DTWInformation;
import timeseriesclustering.GlobalConstraint;
import timeseriesclustering.NoConstraint;
import timeseriesclustering.SakoeChibaBand;
import timeseriesclustering.averaging.ShapeBasedAveraging;
import timeseriesclustering.dataimport.CylinderBellFunnel;

public class SVGOutput {
    public void drawDTWAlignment(String file, Double[] t, Double[] s) {
        this.drawDTWAlignment(file, t, s, new NoConstraint());
    }

    public void drawEuclidianAlignment(String file, Double[] t, Double[] s) {
        this.drawDTWAlignment(file, t, s, new SakoeChibaBand(0));
    }

    public void drawDTWAlignment(String file, Double[] t, Double[] s, GlobalConstraint con) {
        double d;
        int i$;
        int width = Math.max(t.length, s.length) * 10;
        int height = 200;
        double min = t[0];
        double max = t[0];
        Double[] arr$ = t;
        int len$ = arr$.length;
        for (i$ = 0; i$ < len$; ++i$) {
            d = arr$[i$];
            if (d < min) {
                min = d;
            }
            if (!(d > max)) continue;
            max = d;
        }
        arr$ = s;
        len$ = arr$.length;
        for (i$ = 0; i$ < len$; ++i$) {
            d = arr$[i$];
            if (d < min) {
                min = d;
            }
            if (!(d > max)) continue;
            max = d;
        }
        double scale = (double)height / (max - min);
        FileWriter writer = null;
        File f = new File(file);
        try {
            Double y;
            writer = new FileWriter(f);
            BufferedWriter bw = new BufferedWriter(writer);
            bw.write("<svg xmlns=\"http://www.w3.org/2000/svg\" version=\"1.1\" width=\"620px\" height=\"250px\">");
            bw.write("<defs\n     id=\"defs4\">\n    <marker\n       orient=\"auto\"\n       refY=\"0\"\n       refX=\"0\"\n       id=\"Arrow2Mend\"\n       style=\"overflow:visible\">\n      <path\n         id=\"path3864\"\n         style=\"font-size:12px;fill-rule:evenodd;stroke-width:0.625;stroke-linejoin:round\"\n         d=\"M 8.7185878,4.0337352 -2.2072895,0.01601326 8.7185884,-4.0017078 c -1.7454984,2.3720609 -1.7354408,5.6174519 -6e-7,8.035443 z\"\n         transform=\"scale(-0.6,-0.6)\"\n         />\n    </marker>\n    <marker\n         orient=\"auto\"\n       refY=\"0\"\n       refX=\"0\"\n       id=\"Arrow2Mstart\"\n       style=\"overflow:visible\">\n      <path\n         id=\"path3861\"\n         style=\"font-size:12px;fill-rule:evenodd;stroke-width:0.625;stroke-linejoin:round\"\n         d=\"M 8.7185878,4.0337352 -2.2072895,0.01601326 8.7185884,-4.0017078 c -1.7454984,2.3720609 -1.7354408,5.6174519 -6e-7,8.035443 z\"\n         transform=\"scale(0.6,0.6)\"\n         />\n    </marker>\n  </defs>");
            bw.write("<path transform =\"translate(0,30)\" style=\"fill:none;stroke:#000000;stroke-width:2;stroke-linecap:butt;\nstroke-linejoin:miter;stroke-opacity:1;marker-start:url(#Arrow2Mstart);marker-end:url(#Arrow2Mend)\"\n       d=\"M 10,10 10,200 600,200\"/>");
            bw.write("<path style=\"fill:none;stroke:#000000;stroke-width:3;stroke-linecap:butt;stroke-linejoin:miter;stroke-miterlimit:4;stroke-opacity:1\" d=\"M ");
            Double x = 0.0;
            for (Double a : t) {
                y = (a - min) * scale;
                bw.write(10.0 + x / (double)width * 600.0 + "," + y + " ");
                x = x + 10.0;
            }
            bw.write("\"/>");
            bw.write("<path transform =\"translate(0,30)\" style=\"fill:none;stroke:#000000;stroke-width:3;stroke-linecap:butt;stroke-linejoin:miter;stroke-miterlimit:4;stroke-opacity:1;stroke-dasharray:9, 3;stroke-dashoffset:0\" d=\"M ");
            x = 0.0;
            for (Double a : s) {
                y = (a - min) * scale;
                bw.write(10.0 + x / (double)width * 600.0 + "," + y + " ");
                x = x + 10.0;
            }
            bw.write("\"/>");
            DTWInformation dtw = DTW.dtw(s, t, Double.POSITIVE_INFINITY, 0.0, null, null, con);
            DecimalFormat format = new DecimalFormat("#.00");
            bw.write("<text x=\"20\" y=\"20\"> d = " + format.format(dtw.distance) + "</text>");
            bw.write("<g>");
            for (int[] a : dtw.warpingPath) {
                Double x1 = (double)a[0] * 10.0 / (double)width * 600.0 + 10.0;
                Double x2 = (double)a[1] * 10.0 / (double)width * 600.0 + 10.0;
                Double y1 = (s[a[0]] - min) * scale + 30.0;
                Double y2 = (t[a[1]] - min) * scale;
                bw.write("<line style=\"stroke:#bbbbbb;stoke-width:1;stroke-opacity:0.7\" x1 = \"" + x1 + "\" y1 = \"" + y1 + "\" x2=\"" + x2 + "\" y2 = \"" + y2 + "\" />");
            }
            bw.write("</g></svg>");
            bw.close();
        }
        catch (IOException ex) {
            Logger.getLogger(SVGOutput.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void drawShapeBasedAverage(String file, Double[] t, Double[] s) {
        double d;
        int i$;
        int width = Math.max(t.length, s.length) * 10;
        int height = 200;
        double min = t[0];
        double max = t[0];
        Double[] arr$ = t;
        int len$ = arr$.length;
        for (i$ = 0; i$ < len$; ++i$) {
            d = arr$[i$];
            if (d < min) {
                min = d;
            }
            if (!(d > max)) continue;
            max = d;
        }
        arr$ = s;
        len$ = arr$.length;
        for (i$ = 0; i$ < len$; ++i$) {
            d = arr$[i$];
            if (d < min) {
                min = d;
            }
            if (!(d > max)) continue;
            max = d;
        }
        double scale = (double)height / (max - min);
        FileWriter writer = null;
        File f = new File(file);
        try {
            Double y2;
            Double y1;
            Double x2;
            Double x1;
            Double y;
            writer = new FileWriter(f);
            BufferedWriter bw = new BufferedWriter(writer);
            bw.write("<svg xmlns=\"http://www.w3.org/2000/svg\" version=\"1.1\" width=\"620px\" height=\"250px\">");
            bw.write("<defs\n     id=\"defs4\">\n    <marker\n       orient=\"auto\"\n       refY=\"0\"\n       refX=\"0\"\n       id=\"Arrow2Mend\"\n       style=\"overflow:visible\">\n      <path\n         id=\"path3864\"\n         style=\"font-size:12px;fill-rule:evenodd;stroke-width:0.625;stroke-linejoin:round\"\n         d=\"M 8.7185878,4.0337352 -2.2072895,0.01601326 8.7185884,-4.0017078 c -1.7454984,2.3720609 -1.7354408,5.6174519 -6e-7,8.035443 z\"\n         transform=\"scale(-0.6,-0.6)\"\n         />\n    </marker>\n    <marker\n         orient=\"auto\"\n       refY=\"0\"\n       refX=\"0\"\n       id=\"Arrow2Mstart\"\n       style=\"overflow:visible\">\n      <path\n         id=\"path3861\"\n         style=\"font-size:12px;fill-rule:evenodd;stroke-width:0.625;stroke-linejoin:round\"\n         d=\"M 8.7185878,4.0337352 -2.2072895,0.01601326 8.7185884,-4.0017078 c -1.7454984,2.3720609 -1.7354408,5.6174519 -6e-7,8.035443 z\"\n         transform=\"scale(0.6,0.6)\"\n         />\n    </marker>\n  </defs>");
            bw.write("<path transform =\"translate(0,30)\" style=\"fill:none;stroke:#000000;stroke-width:2;stroke-linecap:butt;\nstroke-linejoin:miter;stroke-opacity:1;marker-start:url(#Arrow2Mstart);marker-end:url(#Arrow2Mend)\"\n       d=\"M 10,10 10,200 600,200\"/>");
            bw.write("<path style=\"fill:none;stroke:#000000;stroke-width:3;stroke-linecap:butt;stroke-linejoin:miter;stroke-miterlimit:4;stroke-opacity:1\" d=\"M ");
            Double x = 0.0;
            for (Double a : t) {
                y = (a - min) * scale;
                bw.write(10.0 + x / (double)width * 600.0 + "," + y + " ");
                x = x + 10.0;
            }
            bw.write("\"/>");
            bw.write("<path transform =\"translate(0,30)\" style=\"fill:none;stroke:#000000;stroke-width:3;stroke-linecap:butt;stroke-linejoin:miter;stroke-miterlimit:4;stroke-opacity:1\" d=\"M ");
            x = 0.0;
            for (Double a : s) {
                y = (a - min) * scale;
                bw.write(10.0 + x / (double)width * 600.0 + "," + y + " ");
                x = x + 10.0;
            }
            bw.write("\"/>");
            bw.write("<g>");
            DTWInformation dtw = DTW.dtw(s, t, Double.POSITIVE_INFINITY, 0.0, null, null, new NoConstraint());
            for (int[] a : dtw.warpingPath) {
                x1 = (double)a[0] * 10.0 / (double)width * 600.0 + 10.0;
                x2 = (double)a[1] * 10.0 / (double)width * 600.0 + 10.0;
                y1 = (s[a[0]] - min) * scale + 30.0;
                y2 = (t[a[1]] - min) * scale;
                bw.write("<line style=\"stroke:#bbbbbb;stoke-width:1;stroke-opacity:0.7\" x1 = \"" + x1 + "\" y1 = \"" + y1 + "\" x2=\"" + x2 + "\" y2 = \"" + y2 + "\" />");
            }
            bw.write("</g>");
            bw.write("<path style=\"fill:none;stroke:#000000;stroke-width:3;stroke-linecap:butt;stroke-linejoin:miter;stroke-miterlimit:4;stroke-opacity:1;stroke-dasharray:9, 3;stroke-dashoffset:0\" d=\"M ");
            for (int[] a : dtw.warpingPath) {
                x1 = (double)a[0] * 10.0 / (double)width * 600.0 + 10.0;
                x2 = (double)a[1] * 10.0 / (double)width * 600.0 + 10.0;
                y1 = (s[a[0]] - min) * scale + 30.0;
                y2 = (t[a[1]] - min) * scale;
                bw.write((x1 + x2) / 2.0 + "," + (y1 + y2) / 2.0 + " ");
            }
            bw.write("\"/>");
            bw.write("</svg>");
            bw.close();
        }
        catch (IOException ex) {
            Logger.getLogger(SVGOutput.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void drawTimeSeries(String file, Double[] t) {
        int width = t.length * 10;
        int height = 200;
        double min = t[0];
        double max = t[0];
        Double[] arr$ = t;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            double d = arr$[i$];
            if (d < min) {
                min = d;
            }
            if (!(d > max)) continue;
            max = d;
        }
        double scale = (double)height / (max - min);
        FileWriter writer = null;
        File f = new File(file);
        try {
            writer = new FileWriter(f);
            BufferedWriter bw = new BufferedWriter(writer);
            bw.write("<svg xmlns=\"http://www.w3.org/2000/svg\" version=\"1.1\" width=\"620px\" height=\"220px\">");
            bw.write("<defs\n     id=\"defs4\">\n    <marker\n       orient=\"auto\"\n       refY=\"0\"\n       refX=\"0\"\n       id=\"Arrow2Mend\"\n       style=\"overflow:visible\">\n      <path\n         id=\"path3864\"\n         style=\"font-size:12px;fill-rule:evenodd;stroke-width:0.625;stroke-linejoin:round\"\n         d=\"M 8.7185878,4.0337352 -2.2072895,0.01601326 8.7185884,-4.0017078 c -1.7454984,2.3720609 -1.7354408,5.6174519 -6e-7,8.035443 z\"\n         transform=\"scale(-0.6,-0.6)\"\n         />\n    </marker>\n    <marker\n         orient=\"auto\"\n       refY=\"0\"\n       refX=\"0\"\n       id=\"Arrow2Mstart\"\n       style=\"overflow:visible\">\n      <path\n         id=\"path3861\"\n         style=\"font-size:12px;fill-rule:evenodd;stroke-width:0.625;stroke-linejoin:round\"\n         d=\"M 8.7185878,4.0337352 -2.2072895,0.01601326 8.7185884,-4.0017078 c -1.7454984,2.3720609 -1.7354408,5.6174519 -6e-7,8.035443 z\"\n         transform=\"scale(0.6,0.6)\"\n         />\n    </marker>\n  </defs>");
            bw.write("<path style=\"fill:none;stroke:#000000;stroke-width:2;stroke-linecap:butt;\nstroke-linejoin:miter;stroke-opacity:1;marker-start:url(#Arrow2Mstart);marker-end:url(#Arrow2Mend)\"\n       d=\"M 10,10 10,200 600,200\"/>");
            bw.write("<path style=\"fill:none;stroke:#000000;stroke-width:3;stroke-linecap:butt;stroke-linejoin:miter;stroke-miterlimit:4;stroke-opacity:1\" d=\"M ");
            Double x = 0.0;
            for (Double a : t) {
                Double y = (a - min) * scale;
                bw.write(10.0 + x / (double)width * 600.0 + "," + y + " ");
                x = x + 10.0;
            }
            bw.write("\"/>");
            bw.write("</svg>");
            bw.close();
        }
        catch (IOException ex) {
            Logger.getLogger(SVGOutput.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static void main(String[] args) {
        int i;
        SVGOutput o = new SVGOutput();
        CylinderBellFunnel.factor = 1;
        Double[] s = new Double[50];
        Double[] t = new Double[50];
        for (i = 0; i < s.length; ++i) {
            s[i] = Math.sin(Math.PI * (double)i / 21.0 + 1.015) + 0.75;
        }
        for (i = 0; i < t.length; ++i) {
            t[i] = Math.sin(Math.PI * (double)i / 20.0);
        }
        o.drawDTWAlignment("test2.svg", t, s);
        o.drawEuclidianAlignment("test3.svg", t, s);
        o.drawShapeBasedAverage("test4.svg", t, s);
        ArrayList<Double> time = new ArrayList<Double>();
        ArrayList<Double> value = new ArrayList<Double>();
        for (double x = 0.0; x < 200.0; x += Math.random()) {
            time.add(x);
            value.add(Math.sin(x / 100.0 * Math.PI));
        }
        ShapeBasedAveraging test = new ShapeBasedAveraging();
        Double[] time2 = new Double[time.size()];
        Double[] value2 = new Double[value.size()];
        time.toArray(time2);
        value.toArray(value2);
        Double[] xx = test.resample(time2, value2);
        o.drawTimeSeries("test.svg", xx);
        o.drawTimeSeries("cylinder.svg", CylinderBellFunnel.cylinder());
        o.drawTimeSeries("bell.svg", CylinderBellFunnel.bell());
        o.drawTimeSeries("funnel.svg", CylinderBellFunnel.funnel());
    }
}

