/*
 * Decompiled with CFR 0.152.
 */
package timeseriesclustering.averaging;

import java.util.List;
import timeseriesclustering.GlobalConstraint;
import timeseriesclustering.averaging.AveragingTechnique;

public class EuclidianAveraging
extends AveragingTechnique {
    @Override
    public Double[] average(List<Double[]> cluster, Double[] oldCenter, GlobalConstraint con) {
        int size = cluster.get(0).length;
        int sizeSum = 0;
        int count = 0;
        boolean interpolate = false;
        for (Double[] t : cluster) {
            if (t.length != size) {
                interpolate = true;
            }
            sizeSum += t.length;
            ++count;
        }
        if (interpolate) {
            size = sizeSum / count;
            throw new RuntimeException("Not yet implemented");
        }
        Double[] centroid = new Double[size];
        for (int i = 0; i < size; ++i) {
            centroid[i] = 0.0;
        }
        for (Double[] t : cluster) {
            for (int i = 0; i < size; ++i) {
                Double[] doubleArray = centroid;
                int n = i;
                Double.valueOf(doubleArray[n] + t[i]);
            }
        }
        int i = 0;
        while (i < size) {
            Double[] doubleArray = centroid;
            int n = i++;
            Double.valueOf(doubleArray[n] / (double)count);
        }
        return centroid;
    }

    @Override
    public AveragingTechnique[] duplicateKTimes(int k) {
        AveragingTechnique[] ret = new AveragingTechnique[k];
        for (int i = 0; i < k; ++i) {
            ret[i] = new EuclidianAveraging();
        }
        return ret;
    }
}

