/*
 * Decompiled with CFR 0.152.
 */
package timeseriesclustering;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import timeseriesclustering.GlobalConstraint;
import timeseriesclustering.ParallelQueriesHelper;
import timeseriesclustering.Query;

class ParallelQueries
implements Callable<ParallelQueriesHelper> {
    private List<Double[]> database;
    private List<Double[]> centers;
    private ArrayList<ArrayList<Double[]>> clusters;
    private ArrayList<ArrayList<Double[]>> newClusters;
    private GlobalConstraint con;
    private int start;
    private int end;

    public ParallelQueries(List<Double[]> database, ArrayList<ArrayList<Double[]>> oldClusters, ArrayList<ArrayList<Double[]>> newClusters, List<Double[]> centers, GlobalConstraint con, int start, int end) {
        this.clusters = oldClusters;
        this.newClusters = newClusters;
        this.database = database;
        this.centers = centers;
        this.con = con;
        this.start = start;
        this.end = end;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParallelQueriesHelper call() {
        Query[] ret = new Query[this.end - this.start];
        boolean movements = false;
        double sum = 0.0;
        for (int i = this.start; i < this.end; ++i) {
            ret[i - this.start] = new Query(this.centers, this.database.get(i), this.con);
            sum += ret[i - this.start].dtw.distance;
            if (!movements && !this.clusters.get(ret[i - this.start].id).contains(ret[i - this.start].q)) {
                movements = true;
            }
            ArrayList<Double[]> arrayList = this.newClusters.get(ret[i - this.start].id);
            synchronized (arrayList) {
                this.newClusters.get(ret[i - this.start].id).add(ret[i - this.start].q);
                continue;
            }
        }
        return new ParallelQueriesHelper(sum, movements, ret);
    }
}

