/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.dtw.clustering;

import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.IOObjectCollection;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.TimeSeriesOperator;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.Value;
import com.rapidminer.operator.ValueDouble;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.CollectionMetaData;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.valueseries.Feature;
import com.rapidminer.operator.valueseries.ValueSeries;
import com.rapidminer.operator.valueseries.ValueSeriesMetaData;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.parameter.conditions.BooleanParameterCondition;
import com.rapidminer.parameter.conditions.ParameterCondition;
import com.rapidminer.tools.RandomGenerator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import timeseriesclustering.DTW;
import timeseriesclustering.DegeneratedClusteringException;
import timeseriesclustering.GlobalConstraint;
import timeseriesclustering.NoConstraint;
import timeseriesclustering.SakoeChibaBand;
import timeseriesclustering.TimeSeriesClustering;
import timeseriesclustering.averaging.AveragingTechnique;
import timeseriesclustering.averaging.EuclidianAveraging;
import timeseriesclustering.averaging.FastShapeBasedAveraging;
import timeseriesclustering.averaging.FixpointAveraging;
import timeseriesclustering.averaging.MedoidAveraging;
import timeseriesclustering.averaging.ProjectionAveraging;
import timeseriesclustering.averaging.ShapeBasedAveraging;

public class KMeansClustering
extends TimeSeriesOperator {
    private InputPort timeSeriesInput = this.getInputPorts().createPort("series-in", IOObjectCollection.class);
    private OutputPort timeSeriesOutput = (OutputPort)this.getOutputPorts().createPort("series-out");
    private OutputPort centroidsOutput = (OutputPort)this.getOutputPorts().createPort("centroids-out");
    private TimeSeriesClustering clusterer;

    public KMeansClustering(OperatorDescription description) {
        super(description);
        this.getTransformer().addRule(new MDTransformationRule(){

            public void transformMD() {
                KMeansClustering.this.timeSeriesOutput.deliverMD((MetaData)new CollectionMetaData((MetaData)new ValueSeriesMetaData()));
                KMeansClustering.this.centroidsOutput.deliverMD((MetaData)new CollectionMetaData((MetaData)new ValueSeriesMetaData()));
            }
        });
        this.addValue((Value)new ValueDouble("DTW-Count", "The number of the computed DTW distances."){

            public double getDoubleValue() {
                return DTW.count;
            }
        });
        this.addValue((Value)new ValueDouble("DTW-QueryRatio", "The ratio of the computed DTW distances per Query."){

            public double getDoubleValue() {
                return KMeansClustering.this.clusterer.getDTWRatio();
            }
        });
        this.addValue((Value)new ValueDouble("costs", "The total costs of the computed clustering."){

            public double getDoubleValue() {
                return KMeansClustering.this.clusterer.getCosts();
            }
        });
    }

    public void doWork() throws UserError {
        IOObjectCollection data;
        IOObjectCollection timeseries = data = (IOObjectCollection)this.timeSeriesInput.getData(IOObjectCollection.class);
        HashMap<Double[], ValueSeries> adapterMap = new HashMap<Double[], ValueSeries>();
        this.clusterer = new TimeSeriesClustering();
        RandomGenerator generator = RandomGenerator.getRandomGenerator((Operator)this);
        this.clusterer.setRandom(generator);
        for (ValueSeries v : timeseries.getObjects()) {
            Double[] a = this.convert(v);
            adapterMap.put(a, v);
            this.clusterer.addTimeSeries(a);
        }
        try {
            DTW.count = 0.0;
            int k = this.getParameterAsInt("k");
            boolean plusplus = this.getParameterAsBoolean("kmeans++");
            int maxiterations = this.getParameterAsInt("max iterations");
            GlobalConstraint con = null;
            con = this.getParameterAsBoolean("Sakoe-Chiba-Band") ? new SakoeChibaBand(this.getParameterAsInt("Sakoe-Chiba-Band width")) : new NoConstraint();
            this.clusterer.kMeans(k, con, maxiterations, plusplus, this.getAveragingTechnique(), null);
            ArrayList<ArrayList<Double[]>> clusters = this.clusterer.getClusters();
            ArrayList<Double[]> centers = this.clusterer.getCenters();
            IOObjectCollection centroids = new IOObjectCollection();
            double i = 0.0;
            for (Double[] d : centers) {
                ValueSeries convert = this.convert(d);
                convert.addFeature(new Feature("label", i));
                convert.addFeature(new Feature("size", (double)this.clusterer.getClusters().get((int)i).size()));
                centroids.add((IOObject)convert);
                i += 1.0;
            }
            for (int i2 = 0; i2 < k; ++i2) {
                for (Double[] ts : clusters.get(i2)) {
                    if (!adapterMap.containsKey(ts)) {
                        System.err.println("richtig mieser mist ist hier am abgehen");
                        System.out.println(ts);
                        System.out.println(ts.hashCode());
                        System.out.println(i2);
                    }
                    ((ValueSeries)adapterMap.get(ts)).addFeature(new Feature("cluster", (double)i2));
                    if (!this.getParameterAsBoolean("distances")) continue;
                    for (int j = 0; j < centers.size(); ++j) {
                        Double[] d = centers.get(j);
                        double distance = DTW.dtw((Double[])ts, (Double[])d, (double)Double.POSITIVE_INFINITY, (double)0.0, null, null, (GlobalConstraint)new NoConstraint()).distance;
                        ((ValueSeries)adapterMap.get(ts)).addFeature(new Feature("d" + j, distance));
                    }
                }
            }
            this.timeSeriesOutput.deliver((IOObject)timeseries);
            this.centroidsOutput.deliver((IOObject)centroids);
        }
        catch (DegeneratedClusteringException e) {
            this.doWork();
        }
    }

    private AveragingTechnique getAveragingTechnique() throws UndefinedParameterError {
        String name = this.getParameterAsString("averaging technique");
        if (name.equals("Euclidian")) {
            return new EuclidianAveraging();
        }
        if (name.equals("Projection")) {
            return new ProjectionAveraging();
        }
        if (name.equals("Fixpoint")) {
            return new FixpointAveraging();
        }
        if (name.equals("Shapebased")) {
            return new ShapeBasedAveraging();
        }
        if (name.equals("Fast Shapebased")) {
            return new FastShapeBasedAveraging();
        }
        if (name.equals("Medoids")) {
            return new MedoidAveraging();
        }
        return new EuclidianAveraging();
    }

    public List<ParameterType> getParameterTypes() {
        List types = super.getParameterTypes();
        types.add(new ParameterTypeInt("k", "the number of clusters k-means should compute", 0, Integer.MAX_VALUE, 3));
        types.add(new ParameterTypeBoolean("kmeans++", "use k-means++ initialization", true));
        types.add(new ParameterTypeBoolean("distances", "Save the distances to the calculated centroids", false));
        types.add(new ParameterTypeInt("max iterations", "maximum number of iterations", 0, Integer.MAX_VALUE, 20));
        types.add(new ParameterTypeCategory("averaging technique", "the algorithm used to average a set of time series", new String[]{"Euclidian ", "Projection", "Fixpoint", "Shapebased", "Fast Shapebased", "Medoids"}, 1));
        types.add(new ParameterTypeBoolean("Sakoe-Chiba-Band", "Use a global constraint?", true));
        ParameterTypeInt width = new ParameterTypeInt("Sakoe-Chiba-Band width", "the width of the global constraint. 10% of time series length is a commonly used value", 0, Integer.MAX_VALUE, 16);
        width.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)this, "Sakoe-Chiba-Band", true, true));
        types.add(width);
        types.addAll(RandomGenerator.getRandomGeneratorParameters((Operator)this));
        return types;
    }
}

