/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator;

import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.IOObjectCollection;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.TimeSeriesOperator;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.CollectionMetaData;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.valueseries.Feature;
import com.rapidminer.operator.valueseries.ValueSeries;
import com.rapidminer.operator.valueseries.ValueSeriesMetaData;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.tools.RandomGenerator;
import java.util.List;

public class CylinderBellFunnel
extends TimeSeriesOperator {
    private OutputPort timeSeriesOutput = (OutputPort)this.getOutputPorts().createPort("series-out");

    public CylinderBellFunnel(OperatorDescription description) {
        super(description);
        this.getTransformer().addRule(new MDTransformationRule(){

            public void transformMD() {
                CylinderBellFunnel.this.timeSeriesOutput.deliverMD((MetaData)new CollectionMetaData((MetaData)new ValueSeriesMetaData()));
            }
        });
    }

    public void doWork() throws UserError {
        int n = this.getParameterAsInt("n");
        IOObjectCollection out = new IOObjectCollection();
        block5: for (int i = 0; i < n; ++i) {
            int a = RandomGenerator.getGlobalRandomGenerator().nextIntInRange(0, 3);
            switch (a) {
                case 0: {
                    ValueSeries s = this.convert(timeseriesclustering.dataimport.CylinderBellFunnel.cylinder());
                    s.addFeature(new Feature("label", (double)a));
                    out.add((IOObject)s);
                    continue block5;
                }
                case 1: {
                    ValueSeries s = this.convert(timeseriesclustering.dataimport.CylinderBellFunnel.bell());
                    s.addFeature(new Feature("label", (double)a));
                    out.add((IOObject)s);
                    continue block5;
                }
                case 2: {
                    ValueSeries s = this.convert(timeseriesclustering.dataimport.CylinderBellFunnel.funnel());
                    s.addFeature(new Feature("label", (double)a));
                    out.add((IOObject)s);
                }
            }
        }
        this.timeSeriesOutput.deliver((IOObject)out);
    }

    public List<ParameterType> getParameterTypes() {
        List types = super.getParameterTypes();
        types.add(new ParameterTypeInt("n", "number of TimeSeries to be generated", 0, Integer.MAX_VALUE, 100));
        return types;
    }
}

