/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ProcessSetupError;
import com.rapidminer.operator.clustering.CentroidClusterModel;
import com.rapidminer.operator.clustering.ClusterModel;
import com.rapidminer.operator.learner.PredictionModel;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.Port;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetPassThroughRule;
import com.rapidminer.operator.ports.metadata.ExampleSetPrecondition;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.MetaDataError;
import com.rapidminer.operator.ports.metadata.Precondition;
import com.rapidminer.operator.ports.metadata.SimpleMetaDataError;
import com.rapidminer.tools.container.Tupel;
import com.rapidminer.tools.math.container.LinearList;
import com.rapidminer.tools.math.similarity.DistanceMeasure;
import com.rapidminer.tools.math.similarity.divergences.SquaredEuclideanDistance;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class ClusterToPrediction
extends Operator {
    private final InputPort exampleSetInput = (InputPort)this.getInputPorts().createPort("example set");
    private final InputPort clusterModelInput = this.getInputPorts().createPort("cluster model", ClusterModel.class);
    private final OutputPort exampleSetOutput = (OutputPort)this.getOutputPorts().createPort("example set");
    private final OutputPort clusterModelOutput = (OutputPort)this.getOutputPorts().createPort("cluster model");
    private final OutputPort classificationModelOutput = (OutputPort)this.getOutputPorts().createPort("classification model");

    public ClusterToPrediction(OperatorDescription description) {
        super(description);
        this.exampleSetInput.addPrecondition((Precondition)new ExampleSetPrecondition(this.exampleSetInput, -1, new String[]{"label", "cluster"}));
        this.getTransformer().addRule((MDTransformationRule)new ExampleSetPassThroughRule(this.exampleSetInput, this.exampleSetOutput, null){

            public MetaData modifyMetaData(MetaData metaData) {
                if (metaData instanceof ExampleSetMetaData) {
                    ExampleSetMetaData emd = (ExampleSetMetaData)metaData;
                    switch (emd.hasSpecial("label")) {
                        case NO: {
                            ClusterToPrediction.this.exampleSetInput.addError((MetaDataError)new SimpleMetaDataError(ProcessSetupError.Severity.ERROR, (Port)ClusterToPrediction.this.exampleSetInput, "special_missing", new Object[]{"label"}));
                            return emd;
                        }
                        case UNKNOWN: {
                            ClusterToPrediction.this.exampleSetInput.addError((MetaDataError)new SimpleMetaDataError(ProcessSetupError.Severity.WARNING, (Port)ClusterToPrediction.this.exampleSetInput, "special_unknown", new Object[]{"label"}));
                            return emd;
                        }
                        case YES: {
                            AttributeMetaData predictionMD = AttributeMetaData.createPredictionMetaData((AttributeMetaData)emd.getLabelMetaData());
                            emd.addAttribute(predictionMD);
                            AttributeMetaData.createConfidenceAttributeMetaData((ExampleSetMetaData)emd);
                            return emd;
                        }
                    }
                    return emd;
                }
                return metaData;
            }
        });
        this.getTransformer().addPassThroughRule(this.clusterModelInput, this.clusterModelOutput);
    }

    public void doWork() throws OperatorException {
        ExampleSet exampleSet = (ExampleSet)this.exampleSetInput.getData(ExampleSet.class);
        ClusterModel model = (ClusterModel)this.clusterModelInput.getData(ClusterModel.class);
        Attribute labelAttribute = exampleSet.getAttributes().getLabel();
        PredictionModel.createPredictedLabel((ExampleSet)exampleSet, (Attribute)labelAttribute);
        Attribute predictedLabel = exampleSet.getAttributes().getPredictedLabel();
        System.out.println(exampleSet.getAttributes().toString());
        CentroidClusterModel cm = (CentroidClusterModel)model;
        final LinearList samples = new LinearList((DistanceMeasure)new SquaredEuclideanDistance());
        for (int i = 0; i < model.getNumberOfClusters(); ++i) {
            HashMap<String, Integer> labelOccurrence = new HashMap<String, Integer>();
            for (Example example : exampleSet) {
                String label = example.getValueAsString(labelAttribute);
                if (!labelOccurrence.containsKey(label)) {
                    labelOccurrence.put(label, 0);
                }
                if (example.getValue(example.getAttributes().getCluster()) != (double)i) continue;
                labelOccurrence.put(label, (Integer)labelOccurrence.get(label) + 1);
            }
            int max = 0;
            String maxLabel = "";
            for (Map.Entry e : labelOccurrence.entrySet()) {
                if ((Integer)e.getValue() <= max) continue;
                maxLabel = (String)e.getKey();
                max = (Integer)e.getValue();
            }
            System.out.println("centroids: " + cm.getCentroidCoordinates(i).length);
            samples.add(cm.getCentroidCoordinates(i), (Serializable)((Object)maxLabel));
            for (Example example : exampleSet) {
                String label = example.getValueAsString(labelAttribute);
                if (example.getValue(example.getAttributes().getCluster()) != (double)i) continue;
                example.setValue(predictedLabel, maxLabel);
            }
        }
        this.exampleSetOutput.deliver((IOObject)exampleSet);
        this.clusterModelOutput.deliver((IOObject)model);
        final ArrayList<String> attributesNames = new ArrayList<String>(exampleSet.getAttributes().size());
        for (Attribute a : exampleSet.getAttributes()) {
            attributesNames.add(a.getName());
        }
        this.classificationModelOutput.deliver((IOObject)new PredictionModel(exampleSet){

            public ExampleSet performPrediction(ExampleSet exampleSet, Attribute predictedLabel) throws OperatorException {
                double[] values = new double[attributesNames.size()];
                ArrayList<Attribute> attributes = new ArrayList<Attribute>(attributesNames.size());
                for (String attributeName : attributesNames) {
                    attributes.add(exampleSet.getAttributes().get(attributeName));
                }
                for (Example example : exampleSet) {
                    System.out.println(values.length);
                    System.out.println(example.getAttributes().size());
                    int i = 0;
                    for (Attribute attribute : attributes) {
                        values[i] = example.getValue(attribute);
                        ++i;
                    }
                    Collection nearestValueDistances = samples.getNearestValueDistances(1, values);
                    double min = Double.POSITIVE_INFINITY;
                    for (Tupel t : nearestValueDistances) {
                        if (!((Double)t.getFirst() < min)) continue;
                        min = (Double)t.getFirst();
                        example.setValue(predictedLabel, (String)t.getSecond());
                    }
                }
                return exampleSet;
            }
        });
    }
}

