Android Load Profile Data
============================
This data set consists of 231683 records. The raw data was collected on a Samsung Galaxy Nexus with Android 5.1 and annotated by Benedict Boerger in the course of his Master Thesis "Analyse der Lastprofile von Android-Applikationen" during October 2017. The annotations were post-processed by Nico Piatkowski in March 2018. 

Our data collection infrastructure recorded time stamped system calls, along with various time intervals and tags.
Records are group into files, corresponding to one of five typical use-cases of the Android operating system: "web.csv", "email.csv", "maps.csv", "music.csv", and "youtube.csv". 

## Columns
1. timestamp:	Unix time in microseconds.
* syscall:	System call or Android API call. One of 42 categorical values from [List of collected System and Android API calls](#calls).
* ret:		Return value of *syscall*.
* utime:	Time spent in user-space since last file or network access.
* stime:	Time spent in kernel-space since last file or network access.
* ctxtime:	Time without having the CPU since last file or network access.
* tid:		Thread identifier.
* tag:		Annotation. One of 51 categorical values from [List of Annotations](#annotations).
* ressid:	List of Android package(s) (or similar ressources) which issued *syscall*. 

## <a name="calls"></a>List of collected System and Android API calls
* acquireWakelock_AttachmentService 
* acquireWakelock_Imap Sync WakeLock 
* acquireWakelock_VLC/PlaybackService 
* activityLifecycleMethod_onCreate 
* activityLifecycleMethod_onDestroy 
* activityLifecycleMethod_onPause 
* activityLifecycleMethod_onRestart 
* activityLifecycleMethod_onResume 
* activityLifecycleMethod_onStart 
* activityLifecycleMethod_onStop 
* appStart 
* clearFlagActivity_keepScreenOn 
* clearFlag_keepScreenOn 
* close 
* dup 
* fcntl 
* llseek 
* locationManagerAddGpsStatusListener 
* locationManagerLastKnownPosition_gps 
* locationManagerLastKnownPosition_network 
* locationManagerRemoveGpsStatusListener 
* locationManagerRemoveLocationUpdates 
* locationManagerRequestLocationUpdates_gps_1000 
* lseek 
* openat 
* pread 
* pwrite 
* read 
* releaseWakelock_AttachmentService 
* releaseWakelock_Imap Sync WakeLock 
* releaseWakelock_VLC/PlaybackService 
* RX-IPv4-TCP 
* RX-IPv4-UDP 
* screenOff 
* setFlag_keepScreenOn 
* SOCKET_CLOSE_KNOWN 
* SOCKET_CONNECT_TCP 
* SOCKET_CONNECT_UDP 
* TX-IPv4-TCP 
* TX-IPv4-UDP 
* unlinkat 
* write 

## <a name="annotations"></a>List of Annotations
* answer_mail
* app_restart
* app_start
* app_stop
* back_button
* change_direction
* change_route
* change_transportation_mode
* choose_album
* choose_artist
* choose_song
* enter_search
* image_dialog
* image_rotate
* image_view
* key_stroke
* load_front_page
* load_google_front_page
* load_google_search_results
* load_site
* load_wikipedia
* mail_sync
* move_map
* next_song
* periodic_mail_sync
* periodic_post_mail_sync
* periodic_video_group
* playback_ends
* playing
* playing_start
* playing_stop
* post_mail_sync
* read_mail
* read_mail_html
* route_dialog
* scroll
* search
* search_one_key_stroke
* search_results
* select_location
* select_search_result
* send_mail
* start_playback
* stop_playback
* timeout
* user_quit_app
* video_peridodic
* video_periodic
* wikipedia_local_storage
* write_mail
* zoom

## Acknowledgment
Part of this work has been supported by Deutsche Forschungsgemeinschaft (DFG) within the Collaborative Research Center SFB 876 "Providing Information by Resource-Constrained Analysis", project A1. Visit us at [sfb876.tu-dortmund.de](https://sfb876.tu-dortmund.de).
