/*
 * Decompiled with CFR 0.152.
 */
package com.ximpleware.xpath;

import com.ximpleware.NavException;
import com.ximpleware.NodeTest;
import com.ximpleware.VTDNav;
import com.ximpleware.xpath.LocationPathNode;
import com.ximpleware.xpath.Predicate;

public class Step
implements LocationPathNode {
    public int axis_type;
    public NodeTest nt;
    public Predicate p;
    public Predicate pt;
    public Step nextS;
    public int position;
    public Step prevS;
    public Object o;
    boolean ft;

    public Step() {
        this.nextS = this.prevS = (Step)null;
        this.pt = null;
        this.p = null;
        this.nt = null;
        this.ft = true;
        this.position = 1;
    }

    public void reset(VTDNav vTDNav) {
        this.ft = true;
        this.resetP(vTDNav);
        this.position = 1;
    }

    public void resetP(VTDNav vTDNav) {
        Predicate predicate = this.p;
        while (predicate != null) {
            predicate.reset(vTDNav);
            predicate = predicate.nextP;
        }
    }

    public void resetP(VTDNav vTDNav, Predicate predicate) {
        Predicate predicate2 = this.p;
        while (predicate2 != predicate) {
            predicate2.reset(vTDNav);
            predicate2 = predicate2.nextP;
        }
    }

    public void adjust(int n) {
        Predicate predicate = this.p;
        while (predicate != null) {
            predicate.adjust(n);
            predicate = predicate.nextP;
        }
    }

    public NodeTest getNodeTest() {
        return this.nt;
    }

    public Step getNextStep() {
        return this.nextS;
    }

    public void setNextStep(Step step) {
        this.nextS = step;
    }

    public boolean get_ft() {
        return this.ft;
    }

    public void set_ft(boolean bl) {
        this.ft = bl;
    }

    public Step getPrevStep() {
        return this.prevS;
    }

    public void setPrevStep(Step step) {
        this.prevS = step;
    }

    public void setNodeTest(NodeTest nodeTest) {
        this.nt = nodeTest;
    }

    public void setPredicate(Predicate predicate) {
        if (this.p == null) {
            this.p = this.pt = predicate;
        } else {
            this.pt = this.pt.nextP = predicate;
        }
    }

    @Override
    public boolean eval(VTDNav vTDNav) throws NavException {
        return this.nt.eval(vTDNav) && this.evalPredicates(vTDNav);
    }

    public boolean eval(VTDNav vTDNav, Predicate predicate) throws NavException {
        return this.nt.eval(vTDNav) && this.evalPredicates(vTDNav, predicate);
    }

    public boolean evalPredicates(VTDNav vTDNav) throws NavException {
        Predicate predicate = this.p;
        while (predicate != null) {
            if (!predicate.eval(vTDNav)) {
                return false;
            }
            predicate = predicate.nextP;
        }
        return true;
    }

    public boolean evalPredicates(VTDNav vTDNav, Predicate predicate) throws NavException {
        Predicate predicate2 = this.p;
        while (predicate2 != predicate) {
            if (!predicate2.eval(vTDNav)) {
                return false;
            }
            predicate2 = predicate2.nextP;
        }
        return true;
    }

    public void setAxisType(int n) {
        this.axis_type = n;
    }

    public String toString() {
        String string = this.p == null ? this.axisName(this.axis_type) + this.nt : this.axisName(this.axis_type) + this.nt + " " + this.p;
        if (this.nextS == null) {
            return string;
        }
        return string + "/" + this.nextS.toString();
    }

    public String axisName(int n) {
        switch (n) {
            case 0: {
                return "child::";
            }
            case 1: {
                return "descendant::";
            }
            case 2: {
                return "parent::";
            }
            case 4: {
                return "following-sibling::";
            }
            case 5: {
                return "preceding-sibling::";
            }
            case 6: {
                return "following::";
            }
            case 7: {
                return "preceding::";
            }
            case 8: {
                return "attribute::";
            }
            case 9: {
                return "namespace::";
            }
            case 10: {
                return "self::";
            }
            case 11: {
                return "descendant-or-self::";
            }
            case 3: {
                return "ancestor::";
            }
        }
        return "ancestor-or-self::";
    }
}

