/*
 * Decompiled with CFR 0.152.
 */
package com.ximpleware;

import com.ximpleware.ElementFragmentNs;
import com.ximpleware.FastLongBuffer;
import com.ximpleware.FastObjectBuffer;
import com.ximpleware.ModifyException;
import com.ximpleware.NavException;
import com.ximpleware.ParseException;
import com.ximpleware.TranscodeException;
import com.ximpleware.VTDGen;
import com.ximpleware.VTDNav;
import com.ximpleware.XMLByteOutputStream;
import com.ximpleware.intHash;
import com.ximpleware.transcode.Transcoder;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class XMLModifier {
    protected VTDNav md;
    private static final long MASK_DELETE = 0L;
    private static final long MASK_INSERT_SEGMENT_BYTE = 0x2000000000000000L;
    private static final long MASK_INSERT_BYTE = 0x4000000000000000L;
    private static final long MASK_INSERT_SEGMENT_BYTE_ENCLOSED = 0x6000000000000000L;
    private static final long MASK_INSERT_BYTE_ENCLOSED = Long.MIN_VALUE;
    private static final long MASK_INSERT_FRAGMENT_NS = -6917529027641081856L;
    private static final long MASK_INSERT_FRAGMENT_NS_ENCLOSED = -2305843009213693952L;
    private static final byte[] ba1 = new byte[]{62, 0};
    private static final byte[] ba2 = new byte[]{60, 0};
    private static final byte[] ba3 = new byte[]{0, 62};
    private static final byte[] ba4 = new byte[]{0, 60};
    protected FastObjectBuffer fob;
    protected FastLongBuffer flb;
    protected intHash deleteHash;
    protected intHash insertHash;
    protected String charSet;
    int encoding;

    public XMLModifier(VTDNav vTDNav) throws ModifyException {
        this.bind(vTDNav);
    }

    public XMLModifier() {
        this.md = null;
    }

    public void bind(VTDNav vTDNav) throws ModifyException {
        if (vTDNav == null) {
            throw new IllegalArgumentException("MasterDocument can't be null");
        }
        this.md = vTDNav;
        this.flb = new FastLongBuffer();
        this.fob = new FastObjectBuffer();
        int n = intHash.determineHashWidth(this.md.vtdSize);
        this.insertHash = new intHash(n);
        this.deleteHash = new intHash(n);
        this.encoding = this.md.getEncoding();
        switch (this.encoding) {
            case 0: {
                this.charSet = "ASCII";
                break;
            }
            case 1: {
                this.charSet = "ISO8859_1";
                break;
            }
            case 2: {
                this.charSet = "UTF8";
                break;
            }
            case 63: {
                this.charSet = "UnicodeBigUnmarked";
                break;
            }
            case 64: {
                this.charSet = "UnicodeLittleUnmarked";
                break;
            }
            case 3: {
                this.charSet = "ISO8859_2";
                break;
            }
            case 4: {
                this.charSet = "ISO8859_3";
                break;
            }
            case 5: {
                this.charSet = "ISO8859_4";
                break;
            }
            case 6: {
                this.charSet = "ISO8859_5";
                break;
            }
            case 7: {
                this.charSet = "ISO8859_6";
                break;
            }
            case 8: {
                this.charSet = "ISO8859_7";
                break;
            }
            case 9: {
                this.charSet = "ISO8859_8";
                break;
            }
            case 10: {
                this.charSet = "ISO8859_9";
                break;
            }
            case 11: {
                this.charSet = "ISO8859_10";
                break;
            }
            case 12: {
                this.charSet = "x-iso-8859-11";
                break;
            }
            case 13: {
                this.charSet = "ISO8859_12";
                break;
            }
            case 14: {
                this.charSet = "ISO8859_13";
                break;
            }
            case 15: {
                this.charSet = "ISO8859_14";
                break;
            }
            case 16: {
                this.charSet = "ISO8859_15";
                break;
            }
            case 18: {
                this.charSet = "Cp1250";
                break;
            }
            case 19: {
                this.charSet = "Cp1251";
                break;
            }
            case 20: {
                this.charSet = "Cp1252";
                break;
            }
            case 21: {
                this.charSet = "Cp1253";
                break;
            }
            case 22: {
                this.charSet = "Cp1254";
                break;
            }
            case 23: {
                this.charSet = "Cp1255";
                break;
            }
            case 24: {
                this.charSet = "Cp1256";
                break;
            }
            case 25: {
                this.charSet = "Cp1257";
                break;
            }
            case 26: {
                this.charSet = "Cp1258";
                break;
            }
            default: {
                throw new ModifyException("Master document encoding not yet supported by XML modifier");
            }
        }
    }

    public void remove() throws NavException, ModifyException {
        int n = this.md.getCurrentIndex();
        int n2 = this.md.getTokenType(n);
        if (n2 == 0) {
            long l = this.md.getElementFragment();
            this.removeContent((int)l, (int)(l >> 32));
        } else if (n2 == 2 || n2 == 3) {
            this.removeAttribute(n);
        } else {
            this.removeToken(n);
        }
    }

    public void remove(long l) throws NavException, ModifyException {
        this.removeContent((int)l, (int)(l >> 32));
    }

    public void removeToken(int n) throws ModifyException {
        int n2 = this.md.getTokenType(n);
        int n3 = this.md.getTokenOffset(n);
        int n4 = n2 == 0 || n2 == 2 || n2 == 3 ? this.md.getTokenLength(n) & 0xFFFF : this.md.getTokenLength(n);
        switch (n2) {
            case 11: {
                if (this.encoding < 63) {
                    this.removeContent(n3 - 9, n4 + 12);
                } else {
                    this.removeContent(n3 - 9 << 1, n4 + 12 << 1);
                }
                return;
            }
            case 6: {
                if (this.encoding < 63) {
                    this.removeContent(n3 - 4, n4 + 7);
                } else {
                    this.removeContent(n3 - 4 << 1, n4 + 7 << 1);
                }
                return;
            }
        }
        if (this.encoding < 63) {
            this.removeContent(n3, n4);
        } else {
            this.removeContent(n3 << 1, n4 << 1);
        }
    }

    public void removeAttribute(int n) throws ModifyException {
        int n2 = this.md.getTokenType(n);
        if (n2 != 2 && n2 != 3) {
            throw new ModifyException("token type should be attribute name");
        }
        int n3 = this.md.getTokenOffset(n);
        int n4 = this.md.getTokenOffset(n + 1);
        int n5 = this.md.getTokenLength(n + 1);
        if (this.encoding < 63) {
            this.removeContent(n3, n4 + n5 - n3 + 1);
        } else {
            this.removeContent(n3 << 1, n4 + n5 - n3 + 1 << 1);
        }
    }

    public void removeContent(int n, int n2) throws ModifyException {
        if (n < this.md.docOffset || n2 > this.md.docLen || n + n2 > this.md.docOffset + this.md.docLen) {
            throw new ModifyException("Invalid offset or length for removeContent");
        }
        if (!this.deleteHash.isUnique(n)) {
            throw new ModifyException("There can be only one deletion per offset value");
        }
        this.flb.append((long)n2 << 32 | (long)n | 0L);
        this.fob.append((Object)null);
    }

    private void insertBytesEnclosedAt(int n, byte[] byArray) throws ModifyException {
        if (!this.insertHash.isUnique(n)) {
            throw new ModifyException("There can be only one insert per offset");
        }
        this.flb.append((long)n | Long.MIN_VALUE);
        this.fob.append((Object)byArray);
    }

    public void insertBytesAt(int n, byte[] byArray) throws ModifyException {
        if (!this.insertHash.isUnique(n)) {
            throw new ModifyException("There can be only one insert per offset");
        }
        this.flb.append((long)n | 0x4000000000000000L);
        this.fob.append((Object)byArray);
    }

    private void insertElementFragmentNsAt(int n, ElementFragmentNs elementFragmentNs) throws ModifyException {
        if (!this.insertHash.isUnique(n)) {
            throw new ModifyException("There can be only one insert per offset");
        }
        this.flb.append((long)n | 0xA000000000000000L);
        this.fob.append(elementFragmentNs);
    }

    private void insertElementFragmentNsEnclosedAt(int n, ElementFragmentNs elementFragmentNs) throws ModifyException {
        if (!this.insertHash.isUnique(n)) {
            throw new ModifyException("There can be only one insert per offset");
        }
        this.flb.append((long)n | 0xE000000000000000L);
        this.fob.append(elementFragmentNs);
    }

    public void insertBytesAt(int n, byte[] byArray, int n2, int n3) throws ModifyException {
        if (!this.insertHash.isUnique(n)) {
            throw new ModifyException("There can be only one insert per offset");
        }
        if (n2 < 0 || n3 < 0 || n2 + n3 > byArray.length) {
            throw new ModifyException("Invalid contentOffset and/or contentLen");
        }
        this.flb.append((long)n | 0x2000000000000000L);
        ByteSegment byteSegment = new ByteSegment();
        byteSegment.ba = byArray;
        byteSegment.len = n3;
        byteSegment.offset = n2;
        this.fob.append(byteSegment);
    }

    private void insertBytesEnclosedAt(int n, byte[] byArray, int n2, int n3) throws ModifyException {
        if (!this.insertHash.isUnique(n)) {
            throw new ModifyException("There can be only one insert per offset");
        }
        if (n2 < 0 || n3 < 0 || n2 + n3 > byArray.length) {
            throw new ModifyException("Invalid contentOffset and/or contentLen");
        }
        this.flb.append((long)n | 0x6000000000000000L);
        ByteSegment byteSegment = new ByteSegment();
        byteSegment.ba = byArray;
        byteSegment.len = n3;
        byteSegment.offset = n2;
        this.fob.append(byteSegment);
    }

    private void insertBytesAt(int n, byte[] byArray, long l) throws ModifyException {
        if (!this.insertHash.isUnique(n)) {
            throw new ModifyException("There can be only one insert per offset");
        }
        int n2 = (int)l;
        int n3 = (int)(l >> 32);
        if (n2 < 0 || n3 < 0 || n2 + n3 > byArray.length) {
            throw new ModifyException("Invalid contentOffset and/or contentLen");
        }
        this.flb.append((long)n | 0x2000000000000000L);
        ByteSegment byteSegment = new ByteSegment();
        byteSegment.ba = byArray;
        byteSegment.len = n3;
        byteSegment.offset = n2;
        this.fob.append(byteSegment);
    }

    private void insertBytesEnclosedAt(int n, byte[] byArray, long l) throws ModifyException {
        if (!this.insertHash.isUnique(n)) {
            throw new ModifyException("There can be only one insert per offset");
        }
        int n2 = (int)l;
        int n3 = (int)(l >> 32);
        if (n2 < 0 || n3 < 0 || n2 + n3 > byArray.length) {
            throw new ModifyException("Invalid contentOffset and/or contentLen");
        }
        this.flb.append((long)n | 0x6000000000000000L);
        ByteSegment byteSegment = new ByteSegment();
        byteSegment.ba = byArray;
        byteSegment.len = n3;
        byteSegment.offset = n2;
        this.fob.append(byteSegment);
    }

    public void updateToken(int n, byte[] byArray) throws ModifyException, UnsupportedEncodingException {
        if (byArray == null) {
            throw new IllegalArgumentException("newContentBytes can't be null");
        }
        int n2 = this.md.getTokenOffset(n);
        int n3 = this.md.getTokenType(n);
        switch (n3) {
            case 11: {
                if (this.encoding < 63) {
                    this.insertBytesAt(n2 - 9, byArray);
                    break;
                }
                this.insertBytesAt(n2 - 9 >> 1, byArray);
                break;
            }
            case 6: {
                if (this.encoding < 63) {
                    this.insertBytesAt(n2 - 4, byArray);
                    break;
                }
                this.insertBytesAt(n2 - 4 >> 1, byArray);
                break;
            }
            default: {
                if (this.encoding < 63) {
                    this.insertBytesAt(n2, byArray);
                    break;
                }
                this.insertBytesAt(n2 << 1, byArray);
            }
        }
        this.removeToken(n);
    }

    public void updateToken(int n, byte[] byArray, int n2) throws ModifyException, UnsupportedEncodingException, TranscodeException {
        if (n2 == this.encoding) {
            this.updateToken(n, byArray);
            return;
        }
        if (byArray == null) {
            throw new IllegalArgumentException("newContentBytes can't be null");
        }
        int n3 = this.md.getTokenOffset(n);
        int n4 = this.md.getTokenType(n);
        byte[] byArray2 = Transcoder.transcode(byArray, 0, byArray.length, n2, this.encoding);
        switch (n4) {
            case 11: {
                if (this.encoding < 63) {
                    this.insertBytesAt(n3 - 9, byArray2);
                    break;
                }
                this.insertBytesAt(n3 - 9 >> 1, byArray2);
                break;
            }
            case 6: {
                if (this.encoding < 63) {
                    this.insertBytesAt(n3 - 4, byArray2);
                    break;
                }
                this.insertBytesAt(n3 - 4 >> 1, byArray2);
                break;
            }
            default: {
                if (this.encoding < 63) {
                    this.insertBytesAt(n3, byArray2);
                    break;
                }
                this.insertBytesAt(n3 << 1, byArray2);
            }
        }
        this.removeToken(n);
    }

    public void updateToken(int n, byte[] byArray, int n2, int n3) throws ModifyException, UnsupportedEncodingException {
        if (byArray == null) {
            throw new IllegalArgumentException("newContentBytes can't be null");
        }
        int n4 = this.md.getTokenOffset(n);
        int n5 = this.md.getTokenType(n);
        switch (n5) {
            case 11: {
                if (this.encoding < 63) {
                    this.insertBytesAt(n4 - 9, byArray, n2, n3);
                    break;
                }
                this.insertBytesAt(n4 - 9 << 1, byArray, n2, n3);
                break;
            }
            case 6: {
                if (this.encoding < 63) {
                    this.insertBytesAt(n4 - 4, byArray, n2, n3);
                    break;
                }
                this.insertBytesAt(n4 - 4 << 1, byArray, n2, n3);
                break;
            }
            default: {
                if (this.encoding < 63) {
                    this.insertBytesAt(n4, byArray, n2, n3);
                    break;
                }
                this.insertBytesAt(n4 << 1, byArray, n2, n3);
            }
        }
        this.removeToken(n);
    }

    public void updateToken(int n, byte[] byArray, int n2, int n3, int n4) throws ModifyException, UnsupportedEncodingException, TranscodeException {
        if (n4 == this.encoding) {
            this.updateToken(n, byArray, n2, n3);
            return;
        }
        if (byArray == null) {
            throw new IllegalArgumentException("newContentBytes can't be null");
        }
        int n5 = this.md.getTokenOffset(n);
        int n6 = this.md.getTokenType(n);
        byte[] byArray2 = Transcoder.transcode(byArray, n2, n3, n4, this.encoding);
        switch (n6) {
            case 11: {
                if (this.encoding < 63) {
                    this.insertBytesAt(n5 - 9, byArray2);
                    break;
                }
                this.insertBytesAt(n5 - 9 << 1, byArray2);
                break;
            }
            case 6: {
                if (this.encoding < 63) {
                    this.insertBytesAt(n5 - 4, byArray2);
                    break;
                }
                this.insertBytesAt(n5 - 4 << 1, byArray2);
                break;
            }
            default: {
                if (this.encoding < 63) {
                    this.insertBytesAt(n5, byArray2);
                    break;
                }
                this.insertBytesAt(n5 << 1, byArray2);
            }
        }
        this.removeToken(n);
    }

    public void updateToken(int n, VTDNav vTDNav, int n2, int n3) throws ModifyException, UnsupportedEncodingException, TranscodeException {
        this.updateToken(n, vTDNav.XMLDoc.getBytes(), n2, n3, vTDNav.encoding);
    }

    public void updateToken(int n, String string) throws ModifyException, UnsupportedEncodingException {
        if (string == null) {
            throw new IllegalArgumentException("String newContent can't be null");
        }
        int n2 = this.md.getTokenOffset(n);
        int n3 = this.md.getTokenType(n);
        switch (n3) {
            case 11: {
                if (this.encoding < 63) {
                    this.insertBytesAt(n2 - 9, string.getBytes(this.charSet));
                    break;
                }
                this.insertBytesAt(n2 - 9 << 1, string.getBytes(this.charSet));
                break;
            }
            case 6: {
                if (this.encoding < 63) {
                    this.insertBytesAt(n2 - 4, string.getBytes(this.charSet));
                    break;
                }
                this.insertBytesAt(n2 - 4 << 1, string.getBytes(this.charSet));
                break;
            }
            default: {
                if (this.encoding < 63) {
                    this.insertBytesAt(n2, string.getBytes(this.charSet));
                    break;
                }
                this.insertBytesAt(n2 << 1, string.getBytes(this.charSet));
            }
        }
        this.removeToken(n);
    }

    protected void sort() {
        if (this.flb.size > 0) {
            this.quickSort(0, this.flb.size - 1);
        }
    }

    protected void check() throws ModifyException {
        int n = this.flb.size;
        for (int i = 0; i < n; ++i) {
            int n2;
            int n3 = this.flb.lower32At(i);
            int n4 = this.flb.lower32At(i) + (this.flb.upper32At(i) & 0x1FFFFFFF) - 1;
            if (i + 1 >= n || (n2 = this.flb.lower32At(i + 1)) == n3 || n2 > n4) continue;
            throw new ModifyException("Invalid insertion/deletion condition detected between offset " + n3 + " and offset " + n4);
        }
    }

    public int getUpdatedDocumentSize() throws TranscodeException {
        int n = this.flb.size;
        int n2 = this.md.getXML().getBytes().length;
        int n3 = this.md.encoding < 63 ? 2 : 4;
        for (int i = 0; i < n; ++i) {
            long l = this.flb.longAt(i);
            if ((l & 0xE000000000000000L) == 0L) {
                n2 -= (int)((l & 0x1FFFFFFFFFFFFFFFL) >> 32);
                continue;
            }
            if ((l & 0xE000000000000000L) == 0x4000000000000000L) {
                n2 += ((byte[])this.fob.objectAt(i)).length;
                continue;
            }
            if ((l & 0xE000000000000000L) == 0x2000000000000000L) {
                n2 += ((ByteSegment)this.fob.objectAt((int)i)).len;
                continue;
            }
            if ((l & 0xE000000000000000L) == -6917529027641081856L) {
                n2 += ((ElementFragmentNs)this.fob.objectAt(i)).getSize(this.md.encoding);
                continue;
            }
            if ((l & 0xE000000000000000L) == Long.MIN_VALUE) {
                n2 += ((byte[])this.fob.objectAt(i)).length + n3;
                continue;
            }
            if ((l & 0xE000000000000000L) == 0x6000000000000000L) {
                n2 += ((ByteSegment)this.fob.objectAt((int)i)).len + n3;
                continue;
            }
            if ((l & 0xE000000000000000L) != -2305843009213693952L) continue;
            n2 += ((ElementFragmentNs)this.fob.objectAt(i)).getSize(this.md.encoding) + n3;
        }
        return n2;
    }

    public void insertAfterElement(byte[] byArray) throws ModifyException, NavException {
        int n = this.md.getCurrentIndex();
        int n2 = this.md.getTokenType(n);
        if (n2 != 0) {
            throw new ModifyException("Token type is not a starting tag");
        }
        long l = this.md.getElementFragment();
        int n3 = (int)l;
        int n4 = (int)(l >> 32);
        this.insertBytesAt(n3 + n4, byArray);
    }

    private void insertEndingTag(long l) throws ModifyException {
        int n = this.md.getCurrentIndex();
        int n2 = this.md.getTokenOffset(n);
        int n3 = this.md.getTokenLength(n) & 0xFFFF;
        byte[] byArray = this.md.getXML().getBytes();
        if (this.md.encoding < 63) {
            this.insertBytesAt((int)l, byArray, n2, n3);
        } else {
            this.insertBytesAt((int)l, byArray, n2 << 1, n3 << 1);
        }
    }

    public void insertAfterHead(byte[] byArray) throws ModifyException, NavException {
        long l = this.md.getOffsetAfterHead();
        if (l < 0L) {
            this.insertBytesEnclosedAt((int)l - 1, byArray);
            this.insertEndingTag(l);
            return;
        }
        this.insertBytesAt((int)l, byArray);
    }

    public void insertAfterHead(int n, byte[] byArray) throws ModifyException, NavException, TranscodeException {
        if (n == this.encoding) {
            this.insertAfterHead(byArray);
        } else {
            long l = this.md.getOffsetAfterHead();
            if (l < 0L) {
                byte[] byArray2 = Transcoder.transcode(byArray, 0, byArray.length, n, this.encoding);
                this.insertBytesEnclosedAt((int)l - 1, byArray2);
                this.insertEndingTag(l);
                return;
            }
            byte[] byArray3 = Transcoder.transcode(byArray, 0, byArray.length, n, this.encoding);
            this.insertBytesAt((int)l, byArray3);
        }
    }

    public void insertAfterHead(int n, byte[] byArray, int n2, int n3) throws ModifyException, NavException, TranscodeException {
        if (n == this.encoding) {
            this.insertAfterHead(byArray, n2, n3);
        } else {
            long l = this.md.getOffsetAfterHead();
            if (l < 0L) {
                byte[] byArray2 = Transcoder.transcode(byArray, n2, n3, n, this.encoding);
                this.insertBytesEnclosedAt((int)l - 1, byArray2);
                this.insertEndingTag(l);
                return;
            }
            byte[] byArray3 = Transcoder.transcode(byArray, n2, n3, n, this.encoding);
            this.insertBytesAt((int)l, byArray3, n2, n3);
        }
    }

    public void insertAfterHead(int n, byte[] byArray, long l) throws ModifyException, NavException, TranscodeException {
        if (n == this.encoding) {
            this.insertAfterHead(byArray, l);
        } else {
            long l2 = this.md.getOffsetAfterHead();
            if (l2 < 0L) {
                byte[] byArray2 = Transcoder.transcode(byArray, (int)l, (int)l >> 32, n, this.encoding);
                this.insertBytesEnclosedAt((int)l2 - 1, byArray2, l);
                this.insertEndingTag(l2);
                return;
            }
            byte[] byArray3 = Transcoder.transcode(byArray, (int)l, (int)l >> 32, n, this.encoding);
            this.insertBytesAt((int)l2, byArray3, l);
        }
    }

    public void insertAfterHead(String string) throws ModifyException, UnsupportedEncodingException, NavException {
        long l = this.md.getOffsetAfterHead();
        if (l < 0L) {
            this.insertBytesEnclosedAt((int)l - 1, string.getBytes(this.charSet));
            this.insertEndingTag(l);
            return;
        }
        this.insertBytesAt((int)l, string.getBytes(this.charSet));
    }

    public void insertAfterHead(VTDNav vTDNav, int n, int n2) throws ModifyException, NavException, TranscodeException {
        this.insertAfterHead(vTDNav.encoding, vTDNav.XMLDoc.getBytes(), n, n2);
    }

    public void insertAfterHead(byte[] byArray, int n, int n2) throws ModifyException, NavException {
        long l = this.md.getOffsetAfterHead();
        if (l < 0L) {
            this.insertBytesEnclosedAt((int)l - 1, byArray, n, n2);
            this.insertEndingTag(l);
            return;
        }
        this.insertBytesAt((int)l, byArray, n, n2);
    }

    public void insertAfterHead(byte[] byArray, long l) throws ModifyException, NavException {
        long l2 = this.md.getOffsetAfterHead();
        if (l2 < 0L) {
            this.insertBytesEnclosedAt((int)l2 - 1, byArray, (int)l, (int)(l << 32));
            this.insertEndingTag(l2);
            return;
        }
        this.insertBytesAt((int)l2, byArray, l);
    }

    public void insertAfterHead(ElementFragmentNs elementFragmentNs) throws ModifyException, NavException {
        long l = this.md.getOffsetAfterHead();
        if (l < 0L) {
            this.insertElementFragmentNsEnclosedAt((int)l - 1, elementFragmentNs);
            this.insertEndingTag(l);
            return;
        }
        this.insertElementFragmentNsAt((int)l, elementFragmentNs);
    }

    public void insertAfterElement(ElementFragmentNs elementFragmentNs) throws ModifyException, NavException {
        int n = this.md.getCurrentIndex();
        int n2 = this.md.getTokenType(n);
        if (n2 != 0) {
            throw new ModifyException("Token type is not a starting tag");
        }
        long l = this.md.getElementFragment();
        int n3 = (int)l;
        int n4 = (int)(l >> 32);
        this.insertElementFragmentNsAt(n3 + n4, elementFragmentNs);
    }

    public void insertAfterElement(byte[] byArray, int n, int n2) throws ModifyException, NavException {
        int n3 = this.md.getCurrentIndex();
        int n4 = this.md.getTokenType(n3);
        if (n4 != 0) {
            throw new ModifyException("Token type is not a starting tag");
        }
        long l = this.md.getElementFragment();
        int n5 = (int)l;
        int n6 = (int)(l >> 32);
        this.insertBytesAt(n5 + n6, byArray, n, n2);
    }

    public void insertAfterElement(int n, byte[] byArray, int n2, int n3) throws ModifyException, NavException, TranscodeException {
        if (n == this.encoding) {
            this.insertAfterElement(byArray, n2, n3);
        } else {
            int n4 = this.md.getCurrentIndex();
            int n5 = this.md.getTokenType(n4);
            if (n5 != 0) {
                throw new ModifyException("Token type is not a starting tag");
            }
            long l = this.md.getElementFragment();
            int n6 = (int)l;
            int n7 = (int)(l >> 32);
            byte[] byArray2 = Transcoder.transcode(byArray, n2, n3, n, this.encoding);
            this.insertBytesAt(n6 + n7, byArray2);
        }
    }

    public void insertAfterElement(VTDNav vTDNav, int n, int n2) throws ModifyException, UnsupportedEncodingException, NavException, TranscodeException {
        this.insertAfterElement(vTDNav.encoding, vTDNav.XMLDoc.getBytes(), n, n2);
    }

    public void insertAfterElement(byte[] byArray, long l) throws ModifyException, NavException {
        int n = this.md.getCurrentIndex();
        int n2 = this.md.getTokenType(n);
        if (n2 != 0) {
            throw new ModifyException("Token type is not a starting tag");
        }
        long l2 = this.md.getElementFragment();
        int n3 = (int)l2;
        int n4 = (int)(l2 >> 32);
        this.insertBytesAt(n3 + n4, byArray, l);
    }

    public void insertAfterElement(int n, byte[] byArray, long l) throws ModifyException, UnsupportedEncodingException, NavException, TranscodeException {
        if (n == this.encoding) {
            this.insertAfterElement(byArray, l);
        } else {
            int n2 = this.md.getCurrentIndex();
            int n3 = this.md.getTokenType(n2);
            if (n3 != 0) {
                throw new ModifyException("Token type is not a starting tag");
            }
            long l2 = this.md.getElementFragment();
            int n4 = (int)l2;
            int n5 = (int)(l2 >> 32);
            byte[] byArray2 = Transcoder.transcode(byArray, (int)l2, (int)l2 >> 32, n, this.encoding);
            this.insertBytesAt(n4 + n5, byArray2, l);
        }
    }

    public void insertAfterElement(VTDNav vTDNav, long l) throws ModifyException, UnsupportedEncodingException, NavException, TranscodeException {
        this.insertAfterElement(vTDNav.encoding, vTDNav.XMLDoc.getBytes(), l);
    }

    public void insertAfterHead(VTDNav vTDNav, long l) throws ModifyException, NavException, TranscodeException {
        this.insertAfterHead(vTDNav.encoding, vTDNav.XMLDoc.getBytes(), l);
    }

    public void insertAfterElement(int n, byte[] byArray) throws ModifyException, NavException, TranscodeException {
        if (n == this.encoding) {
            this.insertAfterElement(byArray);
        } else {
            int n2 = this.md.getCurrentIndex();
            int n3 = this.md.getTokenType(n2);
            if (n3 != 0) {
                throw new ModifyException("Token type is not a starting tag");
            }
            long l = this.md.getElementFragment();
            int n4 = (int)l;
            int n5 = (int)(l >> 32);
            byte[] byArray2 = Transcoder.transcode(byArray, 0, byArray.length, n, this.encoding);
            this.insertBytesAt(n4 + n5, byArray2);
        }
    }

    public void insertAfterElement(String string) throws ModifyException, UnsupportedEncodingException, NavException {
        int n = this.md.getCurrentIndex();
        int n2 = this.md.getTokenType(n);
        if (n2 != 0) {
            throw new ModifyException("Token type is not a starting tag");
        }
        long l = this.md.getElementFragment();
        int n3 = (int)l;
        int n4 = (int)(l >> 32);
        this.insertBytesAt(n3 + n4, string.getBytes(this.charSet));
    }

    public void insertBeforeElement(byte[] byArray) throws ModifyException {
        int n = this.md.getCurrentIndex();
        int n2 = this.md.getTokenType(n);
        if (n2 != 0) {
            throw new ModifyException("Token type is not a starting tag");
        }
        int n3 = this.md.getTokenOffset(n) - 1;
        if (this.encoding < 63) {
            this.insertBytesAt(n3, byArray);
        } else {
            this.insertBytesAt(n3 << 1, byArray);
        }
    }

    public void insertBeforeElement(int n, byte[] byArray) throws ModifyException, TranscodeException {
        if (n == this.md.encoding) {
            this.insertBeforeElement(byArray);
        } else {
            int n2 = this.md.getCurrentIndex();
            int n3 = this.md.getTokenType(n2);
            if (n3 != 0) {
                throw new ModifyException("Token type is not a starting tag");
            }
            int n4 = this.md.getTokenOffset(n2) - 1;
            byte[] byArray2 = Transcoder.transcode(byArray, 0, byArray.length, n, this.encoding);
            if (this.encoding < 63) {
                this.insertBytesAt(n4, byArray2);
            } else {
                this.insertBytesAt(n4 << 1, byArray2);
            }
        }
    }

    public void insertBeforeElement(ElementFragmentNs elementFragmentNs) throws ModifyException {
        int n = this.md.getCurrentIndex();
        int n2 = this.md.getTokenType(n);
        if (n2 != 0) {
            throw new ModifyException("Token type is not a starting tag");
        }
        int n3 = this.md.getTokenOffset(n) - 1;
        if (this.encoding < 63) {
            this.insertElementFragmentNsAt(n3, elementFragmentNs);
        } else {
            this.insertElementFragmentNsAt(n3 << 1, elementFragmentNs);
        }
    }

    public void insertBeforeElement(byte[] byArray, int n, int n2) throws ModifyException, UnsupportedEncodingException {
        int n3 = this.md.getCurrentIndex();
        int n4 = this.md.getTokenType(n3);
        if (n4 != 0) {
            throw new ModifyException("Token type is not a starting tag");
        }
        int n5 = this.md.getTokenOffset(n3) - 1;
        if (this.encoding < 63) {
            this.insertBytesAt(n5, byArray, n, n2);
        } else {
            this.insertBytesAt(n5 << 1, byArray, n, n2);
        }
    }

    public void insertBeforeElement(int n, byte[] byArray, int n2, int n3) throws ModifyException, UnsupportedEncodingException, TranscodeException {
        if (n == this.encoding) {
            this.insertBeforeElement(byArray, n2, n3);
        } else {
            int n4 = this.md.getCurrentIndex();
            int n5 = this.md.getTokenType(n4);
            if (n5 != 0) {
                throw new ModifyException("Token type is not a starting tag");
            }
            int n6 = this.md.getTokenOffset(n4) - 1;
            byte[] byArray2 = Transcoder.transcode(byArray, n2, n3, n, this.encoding);
            if (this.encoding < 63) {
                this.insertBytesAt(n6, byArray2);
            } else {
                this.insertBytesAt(n6 << 1, byArray2);
            }
        }
    }

    public void insertBeforeElement(VTDNav vTDNav, int n, int n2) throws ModifyException, UnsupportedEncodingException, TranscodeException {
        this.insertBeforeElement(vTDNav.encoding, vTDNav.XMLDoc.getBytes(), n, n2);
    }

    public void insertBeforeElement(byte[] byArray, long l) throws ModifyException, UnsupportedEncodingException {
        int n = this.md.getCurrentIndex();
        int n2 = this.md.getTokenType(n);
        if (n2 != 0) {
            throw new ModifyException("Token type is not a starting tag");
        }
        int n3 = this.md.getTokenOffset(n) - 1;
        if (this.encoding < 63) {
            this.insertBytesAt(n3, byArray, l);
        } else {
            this.insertBytesAt(n3 << 1, byArray, l);
        }
    }

    public void insertBeforeElement(int n, byte[] byArray, long l) throws ModifyException, UnsupportedEncodingException, TranscodeException {
        if (n == this.md.encoding) {
            this.insertBeforeElement(byArray, l);
        } else {
            int n2 = this.md.getCurrentIndex();
            int n3 = this.md.getTokenType(n2);
            if (n3 != 0) {
                throw new ModifyException("Token type is not a starting tag");
            }
            int n4 = this.md.getTokenOffset(n2) - 1;
            byte[] byArray2 = Transcoder.transcode(byArray, (int)l, (int)(l >> 32), n, this.encoding);
            if (this.encoding < 63) {
                this.insertBytesAt(n4, byArray2);
            } else {
                this.insertBytesAt(n4 << 1, byArray2);
            }
        }
    }

    public void insertBeforeElement(VTDNav vTDNav, long l) throws ModifyException, UnsupportedEncodingException, TranscodeException {
        this.insertBeforeElement(vTDNav.encoding, vTDNav.XMLDoc.getBytes(), l);
    }

    public void insertBeforeElement(String string) throws ModifyException, UnsupportedEncodingException {
        int n = this.md.getCurrentIndex();
        int n2 = this.md.getTokenType(n);
        if (n2 != 0) {
            throw new ModifyException("Token type is not a starting tag");
        }
        int n3 = this.md.getTokenOffset(n) - 1;
        if (this.encoding < 63) {
            this.insertBytesAt(n3, string.getBytes(this.charSet));
        } else {
            this.insertBytesAt(n3 << 1, string.getBytes(this.charSet));
        }
    }

    public void insertAttribute(String string) throws ModifyException, UnsupportedEncodingException {
        int n = this.md.getCurrentIndex();
        int n2 = this.md.getTokenType(n);
        if (n2 != 0) {
            throw new ModifyException("Token type is not a starting tag");
        }
        int n3 = this.md.getTokenOffset(n);
        int n4 = this.md.getTokenLength(n) & 0xFFFF;
        if (this.encoding < 63) {
            this.insertBytesAt(n3 + n4, string.getBytes(this.charSet));
        } else {
            this.insertBytesAt(n3 + n4 << 1, string.getBytes(this.charSet));
        }
    }

    public void insertAttribute(byte[] byArray) throws ModifyException, UnsupportedEncodingException {
        int n = this.md.getCurrentIndex();
        int n2 = this.md.getTokenType(n);
        if (n2 != 0) {
            throw new ModifyException("Token type is not a starting tag");
        }
        int n3 = this.md.getTokenOffset(n);
        int n4 = this.md.getTokenLength(n) & 0xFFFF;
        if (this.encoding < 63) {
            this.insertBytesAt(n3 + n4, byArray);
        } else {
            this.insertBytesAt(n3 + n4 << 1, byArray);
        }
    }

    public void insertAttribute(int n, byte[] byArray) throws ModifyException, UnsupportedEncodingException, TranscodeException {
        int n2 = this.md.getCurrentIndex();
        int n3 = this.md.getTokenType(n2);
        if (n3 != 0) {
            throw new ModifyException("Token type is not a starting tag");
        }
        int n4 = this.md.getTokenOffset(n2);
        int n5 = this.md.getTokenLength(n2) & 0xFFFF;
        byte[] byArray2 = Transcoder.transcode(byArray, 0, byArray.length, n, this.encoding);
        if (this.encoding < 63) {
            this.insertBytesAt(n4 + n5, byArray2);
        } else {
            this.insertBytesAt(n4 + n5 << 1, byArray2);
        }
    }

    public void output(OutputStream outputStream) throws IOException, ModifyException, TranscodeException {
        int n;
        if (outputStream == null) {
            throw new IllegalArgumentException("OutputStream can't be null");
        }
        this.sort();
        this.check();
        byte[] byArray = this.md.getXML().getBytes();
        int n2 = this.md.vtdBuffer.lower32At(0);
        int n3 = n2 == 0 ? this.md.docOffset : 32;
        int n4 = n = n2 == 0 ? this.md.docLen : this.md.docLen - 32;
        if (this.flb.size == 0) {
            outputStream.write(byArray, n3, n);
        } else if (this.md.encoding < 63) {
            int n5 = n3;
            int n6 = 1;
            for (int i = 0; i < this.flb.size; i += n6) {
                Object object;
                n6 = i + 1 == this.flb.size ? 1 : (this.flb.lower32At(i) == this.flb.lower32At(i + 1) ? 2 : 1);
                long l = this.flb.longAt(i);
                if (n6 == 1) {
                    if ((l & 0xE000000000000000L) == 0L) {
                        outputStream.write(byArray, n5, this.flb.lower32At(i) - n5);
                        n5 = this.flb.lower32At(i) + (this.flb.upper32At(i) & 0x1FFFFFFF);
                        continue;
                    }
                    if ((l & 0xE000000000000000L) == 0x4000000000000000L) {
                        outputStream.write(byArray, n5, this.flb.lower32At(i) - n5);
                        outputStream.write((byte[])this.fob.objectAt(i));
                        n5 = this.flb.lower32At(i);
                        continue;
                    }
                    if ((l & 0xE000000000000000L) == 0x2000000000000000L) {
                        outputStream.write(byArray, n5, this.flb.lower32At(i) - n5);
                        ByteSegment byteSegment = (ByteSegment)this.fob.objectAt(i);
                        outputStream.write(byteSegment.ba, byteSegment.offset, byteSegment.len);
                        n5 = this.flb.lower32At(i);
                        continue;
                    }
                    if ((l & 0xE000000000000000L) == -6917529027641081856L) {
                        outputStream.write(byArray, n5, this.flb.lower32At(i) - n5);
                        ElementFragmentNs elementFragmentNs = (ElementFragmentNs)this.fob.objectAt(i);
                        elementFragmentNs.writeToOutputStream(outputStream, this.md.encoding);
                        n5 = this.flb.lower32At(i);
                        continue;
                    }
                    if ((l & 0xE000000000000000L) == Long.MIN_VALUE) {
                        outputStream.write(byArray, n5, this.flb.lower32At(i) - n5);
                        outputStream.write(62);
                        outputStream.write((byte[])this.fob.objectAt(i));
                        outputStream.write(60);
                        n5 = this.flb.lower32At(i);
                        continue;
                    }
                    if ((l & 0xE000000000000000L) == 0x6000000000000000L) {
                        outputStream.write(byArray, n5, this.flb.lower32At(i) - n5);
                        ByteSegment byteSegment = (ByteSegment)this.fob.objectAt(i);
                        outputStream.write(62);
                        outputStream.write(byteSegment.ba, byteSegment.offset, byteSegment.len);
                        outputStream.write(60);
                        n5 = this.flb.lower32At(i);
                        continue;
                    }
                    if ((l & 0xE000000000000000L) != -2305843009213693952L) continue;
                    outputStream.write(byArray, n5, this.flb.lower32At(i) - n5);
                    ElementFragmentNs elementFragmentNs = (ElementFragmentNs)this.fob.objectAt(i);
                    outputStream.write(62);
                    elementFragmentNs.writeToOutputStream(outputStream, this.md.encoding);
                    outputStream.write(60);
                    n5 = this.flb.lower32At(i);
                    continue;
                }
                long l2 = this.flb.longAt(i + 1);
                int n7 = i;
                int n8 = i + 1;
                if ((l & 0xE000000000000000L) != 0L) {
                    long l3 = l;
                    l = l2;
                    l2 = l3;
                    int n9 = n7;
                    n7 = n8;
                    n8 = n9;
                }
                outputStream.write(byArray, n5, this.flb.lower32At(n7) - n5);
                if ((l2 & 0xE000000000000000L) == 0x4000000000000000L) {
                    outputStream.write((byte[])this.fob.objectAt(n8));
                    n5 = this.flb.lower32At(n7) + (this.flb.upper32At(n7) & 0x1FFFFFFF);
                    continue;
                }
                if ((l2 & 0xE000000000000000L) == 0x2000000000000000L) {
                    object = (ByteSegment)this.fob.objectAt(n8);
                    outputStream.write(((ByteSegment)object).ba, ((ByteSegment)object).offset, ((ByteSegment)object).len);
                    n5 = this.flb.lower32At(n7) + (this.flb.upper32At(n7) & 0x1FFFFFFF);
                    continue;
                }
                if ((l2 & 0xE000000000000000L) == -6917529027641081856L) {
                    object = (ElementFragmentNs)this.fob.objectAt(n8);
                    ((ElementFragmentNs)object).writeToOutputStream(outputStream, this.md.encoding);
                    n5 = this.flb.lower32At(n7) + (this.flb.upper32At(n7) & 0x1FFFFFFF);
                    continue;
                }
                if ((l2 & 0xE000000000000000L) == Long.MIN_VALUE) {
                    outputStream.write(62);
                    outputStream.write((byte[])this.fob.objectAt(n8));
                    outputStream.write(60);
                    n5 = this.flb.lower32At(n7) + (this.flb.upper32At(n7) & 0x1FFFFFFF);
                    continue;
                }
                if ((l2 & 0xE000000000000000L) == 0x6000000000000000L) {
                    object = (ByteSegment)this.fob.objectAt(n8);
                    outputStream.write(62);
                    outputStream.write(((ByteSegment)object).ba, ((ByteSegment)object).offset, ((ByteSegment)object).len);
                    outputStream.write(60);
                    n5 = this.flb.lower32At(n7) + (this.flb.upper32At(n7) & 0x1FFFFFFF);
                    continue;
                }
                if ((l2 & 0xE000000000000000L) != -2305843009213693952L) continue;
                object = (ElementFragmentNs)this.fob.objectAt(n8);
                outputStream.write(62);
                ((ElementFragmentNs)object).writeToOutputStream(outputStream, this.md.encoding);
                outputStream.write(60);
                n5 = this.flb.lower32At(n7) + (this.flb.upper32At(n7) & 0x1FFFFFFF);
            }
            outputStream.write(byArray, n5, n3 + n - n5);
        } else {
            byte[] byArray2 = ba1;
            byte[] byArray3 = ba2;
            if (this.md.encoding == 63) {
                byArray2 = ba3;
                byArray3 = ba4;
            }
            int n10 = n3;
            int n11 = 1;
            for (int i = 0; i < this.flb.size; i += n11) {
                Object object;
                n11 = i + 1 == this.flb.size ? 1 : (this.flb.lower32At(i) == this.flb.lower32At(i + 1) ? 2 : 1);
                long l = this.flb.longAt(i);
                if (n11 == 1) {
                    if ((l & 0xE000000000000000L) == 0L) {
                        outputStream.write(byArray, n10, (this.flb.lower32At(i) << 1) - n10);
                        n10 = this.flb.lower32At(i) + (this.flb.upper32At(i) & 0x1FFFFFFF) << 1;
                        continue;
                    }
                    if ((l & 0xE000000000000000L) == 0x4000000000000000L) {
                        outputStream.write(byArray, n10, (this.flb.lower32At(i) << 1) - n10);
                        outputStream.write((byte[])this.fob.objectAt(i));
                        n10 = this.flb.lower32At(i) << 1;
                        continue;
                    }
                    if ((l & 0xE000000000000000L) == 0x2000000000000000L) {
                        outputStream.write(byArray, n10, (this.flb.lower32At(i) << 1) - n10);
                        ByteSegment byteSegment = (ByteSegment)this.fob.objectAt(i);
                        outputStream.write(byteSegment.ba, byteSegment.offset, byteSegment.len);
                        n10 = this.flb.lower32At(i) << 1;
                        continue;
                    }
                    if ((l & 0xE000000000000000L) == -6917529027641081856L) {
                        outputStream.write(byArray, n10, (this.flb.lower32At(i) << 1) - n10);
                        ElementFragmentNs elementFragmentNs = (ElementFragmentNs)this.fob.objectAt(i);
                        elementFragmentNs.writeToOutputStream(outputStream, this.md.encoding);
                        n10 = this.flb.lower32At(i) << 1;
                        continue;
                    }
                    if ((l & 0xE000000000000000L) == Long.MIN_VALUE) {
                        outputStream.write(byArray, n10, (this.flb.lower32At(i) << 1) - n10);
                        outputStream.write(byArray2);
                        outputStream.write((byte[])this.fob.objectAt(i));
                        outputStream.write(byArray3);
                        n10 = this.flb.lower32At(i) << 1;
                        continue;
                    }
                    if ((l & 0xE000000000000000L) == 0x6000000000000000L) {
                        outputStream.write(byArray, n10, (this.flb.lower32At(i) << 1) - n10);
                        ByteSegment byteSegment = (ByteSegment)this.fob.objectAt(i);
                        outputStream.write(byArray2);
                        outputStream.write(byteSegment.ba, byteSegment.offset, byteSegment.len);
                        outputStream.write(byArray3);
                        n10 = this.flb.lower32At(i) << 1;
                        continue;
                    }
                    if ((l & 0xE000000000000000L) != -2305843009213693952L) continue;
                    outputStream.write(byArray, n10, (this.flb.lower32At(i) << 1) - n10);
                    ElementFragmentNs elementFragmentNs = (ElementFragmentNs)this.fob.objectAt(i);
                    outputStream.write(byArray2);
                    elementFragmentNs.writeToOutputStream(outputStream, this.md.encoding);
                    outputStream.write(byArray3);
                    n10 = this.flb.lower32At(i) << 1;
                    continue;
                }
                long l4 = this.flb.longAt(i + 1);
                int n12 = i;
                int n13 = i + 1;
                if ((l & 0xE000000000000000L) != 0L) {
                    long l5 = l;
                    l = l4;
                    l4 = l5;
                    int n14 = n12;
                    n12 = n13;
                    n13 = n14;
                }
                outputStream.write(byArray, n10, (this.flb.lower32At(n12) << 1) - n10);
                if ((l4 & 0xE000000000000000L) == 0x4000000000000000L) {
                    outputStream.write((byte[])this.fob.objectAt(n13));
                    n10 = this.flb.lower32At(n12) + (this.flb.upper32At(n12) & 0x1FFFFFFF) << 1;
                    continue;
                }
                if ((l4 & 0xE000000000000000L) == 0x2000000000000000L) {
                    object = (ByteSegment)this.fob.objectAt(n13);
                    outputStream.write(((ByteSegment)object).ba, ((ByteSegment)object).offset, ((ByteSegment)object).len);
                    n10 = this.flb.lower32At(n12) + (this.flb.upper32At(n12) & 0x1FFFFFFF) << 1;
                    continue;
                }
                if ((l4 & 0xE000000000000000L) == -6917529027641081856L) {
                    object = (ElementFragmentNs)this.fob.objectAt(n13);
                    ((ElementFragmentNs)object).writeToOutputStream(outputStream, this.md.encoding);
                    n10 = this.flb.lower32At(n12) + (this.flb.upper32At(n12) & 0x1FFFFFFF) << 1;
                    continue;
                }
                if ((l4 & 0xE000000000000000L) == Long.MIN_VALUE) {
                    outputStream.write(byArray2);
                    outputStream.write((byte[])this.fob.objectAt(n13));
                    outputStream.write(byArray3);
                    n10 = this.flb.lower32At(n12) + (this.flb.upper32At(n12) & 0x1FFFFFFF) << 1;
                    continue;
                }
                if ((l4 & 0xE000000000000000L) == 0x6000000000000000L) {
                    object = (ByteSegment)this.fob.objectAt(n13);
                    outputStream.write(byArray2);
                    outputStream.write(((ByteSegment)object).ba, ((ByteSegment)object).offset, ((ByteSegment)object).len);
                    outputStream.write(byArray3);
                    n10 = this.flb.lower32At(n12) + (this.flb.upper32At(n12) & 0x1FFFFFFF) << 1;
                    continue;
                }
                if ((l4 & 0xE000000000000000L) != -2305843009213693952L) continue;
                object = (ElementFragmentNs)this.fob.objectAt(n13);
                outputStream.write(byArray2);
                ((ElementFragmentNs)object).writeToOutputStream(outputStream, this.md.encoding);
                outputStream.write(byArray3);
                n10 = this.flb.lower32At(n12) + (this.flb.upper32At(n12) & 0x1FFFFFFF) << 1;
            }
            outputStream.write(byArray, n10, n3 + n - n10);
        }
    }

    public void output(String string) throws IOException, ModifyException, TranscodeException {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        this.output(fileOutputStream);
        fileOutputStream.close();
    }

    void quickSort(int n, int n2) {
        int n3 = n;
        int n4 = n2;
        int n5 = this.flb.lower32At((n + n2) / 2);
        while (true) {
            if (this.flb.lower32At(n3) < n5) {
                ++n3;
                continue;
            }
            while (this.flb.lower32At(n4) > n5) {
                --n4;
            }
            if (n3 <= n4) {
                long l = this.flb.longAt(n3);
                Object object = this.fob.objectAt(n3);
                this.flb.modifyEntry(n3, this.flb.longAt(n4));
                this.fob.modifyEntry(n3, this.fob.objectAt(n4));
                this.flb.modifyEntry(n4, l);
                this.fob.modifyEntry(n4, object);
                ++n3;
                --n4;
            }
            if (n3 > n4) break;
        }
        if (n < n4) {
            this.quickSort(n, n4);
        }
        if (n3 < n2) {
            this.quickSort(n3, n2);
        }
    }

    public void reset() {
        if (this.flb != null) {
            this.flb.size = 0;
        }
        if (this.fob != null) {
            this.fob.size = 0;
        }
        if (this.insertHash != null) {
            this.insertHash.reset();
        }
        if (this.deleteHash != null) {
            this.deleteHash.reset();
        }
    }

    public void updateElementName(String string) throws ModifyException, NavException, UnsupportedEncodingException {
        int n = this.md.getCurrentIndex();
        int n2 = this.md.getTokenType(n);
        if (n2 != 0) {
            throw new ModifyException("You can only update an element name");
        }
        int n3 = this.md.getTokenLength(n) & 0xFFFF;
        this.updateToken(n, string);
        long l = this.md.getElementFragment();
        int n4 = this.md.getEncoding();
        byte[] byArray = this.md.getXML().getBytes();
        int n5 = (int)l + (int)(l >> 32);
        if (n4 < 63) {
            if (byArray[n5 - 2] == 47) {
                return;
            }
            --n5;
            while (byArray[n5] != 47) {
                --n5;
            }
            this.insertBytesAt(n5 + 1, string.getBytes(this.charSet));
            this.removeContent(n5 + 1, n3);
            return;
        }
        if (n4 == 63) {
            if (byArray[n5 - 3] == 47 && byArray[n5 - 4] == 0) {
                return;
            }
            n5 -= 2;
            while (byArray[n5 + 1] != 47 || byArray[n5] != 0) {
                n5 -= 2;
            }
            this.insertBytesAt(n5 + 2, string.getBytes(this.charSet));
            this.removeContent(n5 + 2, n3 << 1);
        } else {
            if (byArray[n5 - 3] == 0 && byArray[n5 - 4] == 47) {
                return;
            }
            n5 -= 2;
            while (byArray[n5] != 47 || byArray[n5 + 1] != 0) {
                n5 -= 2;
            }
            this.insertBytesAt(n5 + 2, string.getBytes(this.charSet));
            this.removeContent(n5 + 2, n3 << 1);
        }
    }

    public VTDNav outputAndReparse() throws ParseException, IOException, TranscodeException, ModifyException {
        XMLByteOutputStream xMLByteOutputStream = new XMLByteOutputStream(this.getUpdatedDocumentSize());
        this.output(xMLByteOutputStream);
        VTDGen vTDGen = new VTDGen();
        vTDGen.setDoc(xMLByteOutputStream.getXML());
        vTDGen.parse(this.md.ns);
        return vTDGen.getNav();
    }

    public class ByteSegment {
        byte[] ba;
        int offset;
        int len;
    }
}

