function [y1] = BQ70_TS50TS(x1)
% BQ70_TS50TS is neural network simulation function.
% It predicts TI BQ25570 efficiency according to the input voltage and
% current in addition to the storage voltage.
% 
% [y] = BQ70_TS50TS(x) takes these arguments as:
%   x = [Vin, Vstr, Ii]'
%       Voltage values in V (Volt)
%       Current value in uA (micro Ampere)
% and returns:
%   y = efficiency (in percent)
% 
% This model has a single hidden layer including 50 neurons with tangent sigmoid transfer function 
% and  a single neuron tangent sigmoid transfer function output layer.

% Coperight: Mojtaba Masoudinejad, 2018, Dortmund
% mojtaba.masoudinejad@tu-dortmund.de

% ===== NEURAL NETWORK CONSTANTS =====

% Input 1
x1_step1.xoffset = [0.328;1.5999;0.5];
x1_step1.gain = [0.447727781508843;0.769201184569824;1.99005965203807e-05];
x1_step1.ymin = -1;

% Layer 1
b1 = [0.97332850210738852681;102.83686259388271367;363.78088329763119191;26.422053653989568289;245.64797848645960698;5.3583413855485684252;-25.323156397812336849;601.7933111764801879;-32.827454913510983658;-146.13212770051458733;1.0097144419309616037;1.3193725610918169977;158.46174170855087482;7.3738454180160246665;1028.4691198232776514;693.05844664247786113;-510.28700455202181274;-3.8201442619992120875;-237.44466993276463995;-270.25100115041249182;710.49895472108039485;70.569705915143899233;-1.2126466820256500689;37.221499869896284451;161.00121084263162174;82.066176221330763951;158.61800574171266476;1273.4774311200278589;639.6346115412538893;-36.846330176043274207;74.945442666846318502;150.64920106566233926;-202.64502294846670338;-7.4421316827651127213;-80.934219220378494697;-159.43091404432337299;-110.17061874267021437;27.796772263977270967;3.225888579365622455;-154.57144564703656897;161.43006082815057312;-84.245026721845505335;752.33723742167956061;493.62011989779051646;83.778955472954265815;-296.19172256880142413;-473.88997746440992387;5.4653489882272019429;507.35186956633776845;-72.559648616827047363];
IW1_1 = [0.45737948156302621339 0.44709872736971384422 0.18614058860599327905;-102.87451087471234246 -38.594795885025220628 140.10322180616202559;-3.6269653555165368708 1.4648422406069268042 356.48012872611957391;-69.993593050204879091 -9.0921043141849313685 -1.5164191779219449163;1.6715866976318247694 65.427725315874553758 184.94987848333698821;7.3793488033544738514 -0.10376368838586884358 -0.19196412079820038277;67.034759204637239804 8.6734928280610485984 1.4041727678179536376;0.1646532648500443341 -0.0036362803576760194257 601.64821017420149474;34.228202569357151219 -35.190702683489561764 -12.173294359825938216;241.98186197413670584 -126.41755057378234994 -188.61145823963155976;0.47306163108508397785 0.39404765870907476621 0.19473799716930098591;0.63872852377798061685 -0.058441382953134300704 0.36730008040658684854;-8.5985430108664893112 5.9975188354077655362 159.72551737477061806;-54.629522013163949623 31.251884299812484613 0.76837430775039294861;0.10295041962831209814 -0.030175376039462967898 1026.7830821465508961;0.91677570053217682933 -0.15470862183482292362 691.68667065049010034;0.55317369540149607943 -0.12750801232559688669 -508.23720955581143244;-1.4698931037864748639 0.014414151190517282553 -0.17730610856582548762;101.66817145082805496 -58.151497282321791715 -230.02516364961851991;0.22915784133224839647 -2.041685118850767644 -269.61896361334800076;0.21899770725478837075 -0.0061271231682902488683 710.3954994470177553;-69.440731702595826391 -26.197118062278725859 96.03421397074598076;-0.62296255921574739123 0.021158634075646078759 -0.37956658307352697523;175.04432192516119926 14.201567997564858103 -23.085786835953285845;-52.681092022290378907 39.905973844368887171 149.66838450267158578;-4.7177420077380114449 -19.365616618212396105 61.013810354631893063;-8.6181852739762216942 6.0122112784258767704 159.88387831084051527;0.37576506256563507735 -0.055890658059107367617 1272.577607474810975;0.62235143525467162551 -0.1056629483206053266 638.33901868595148699;29.889555272849126055 -83.007980094804622695 -26.705490428988362339;16.43184623867718841 6.025958766205886441 76.005344880865891355;-249.46218545643293396 130.34254486346182489 194.43150382786529917;67.814125253822453487 -136.11736450623999417 -131.25124963699241221;55.113949049785716738 -31.522236529168559116 -0.76795604693891372783;-17.5207288581050733 -6.3498479735623671871 -82.021272435048885541;12.571029810808036942 -12.573289775187538098 -150.51888380424628622;44.384249077260449212 -27.829634099270215586 -113.67914003220961661;-73.695541596618909352 -9.6230340602943122974 -1.6613049481425963272;-25.231311111445911877 17.21165720264662724 -7.4413242541595092661;255.9619738756988454 -133.75267054000553912 -199.48540555958342679;-52.778896983097673967 39.980310385411797824 150.07499159976160286;4.8395630943361611642 19.243876656608623676 -63.272299740551225966;0.12337862466375383586 0.015976383349047267035 752.04265713011079697;0.21830660516667307891 0.039229258098718626513 493.77184769133066311;-32.754744248853434385 16.374730029347070115 89.498084390107848662;83.806270144872314631 -45.007100682187363816 -311.98505613058341623;149.3327560437182342 -114.100807786306504 -444.67626895886479588;7.5689852883825317065 -0.11650840604980186588 -0.18645569474576406677;0.21415866152462079142 0.02547466992810381442 507.62412343480627896;90.22378822880669702 -20.83572568731323571 -135.74349750279890259];

% Layer 2
b2 = -101.52141035040204997;
LW2_1 = [-32.04652615277532135 0.13661971684682347461 -172.08972645931143575 41.643425962582121258 58.669729892443477581 8.2754499436548041302 23.07068629139881466 349.84965515559412097 86.923861912301717325 36.323258928037631676 41.17243746934821047 49.253790088994271912 25.993422297738842275 20.951128082088512627 712.21677399986504042 -109.47385801252301007 340.88727585288552291 94.659159935961127985 0.2142319594721439624 0.17218640757349434889 -403.73999805015370157 -0.13830092862191153968 47.581232083180111658 -0.011424209675620184204 155.53585055527915415 53.95928039447025526 -25.95930110532746582 -206.61841558661078011 360.94106872938817787 -0.009685918319024213255 0.90949268568369745491 79.524791485965863558 -0.05159778487115328216 20.684305634696670495 0.9046683885728402652 90.039558034456675273 0.050715914061610196939 -18.583421655812951911 0.076827682811710776289 43.194582431274547218 -155.02080503703618319 52.595556542230177399 133.85469596140194426 173.73588514605077648 0.071796742460600179725 0.025579260556283948957 0.24629201100948977521 -7.8896007529698026772 -194.76566393238192632 0.0096860966394155447595];

% Output 1
y1_step1.ymin = -1;
y1_step1.gain = 0.0200002226111087;
y1_step1.xoffset = 2.37595156899639e-05;

% ===== SIMULATION ========

% Dimensions
Q = size(x1,2); % samples

% Input 1
xp1 = mapminmax_apply(x1,x1_step1);

% Layer 1
a1 = tansig_apply(repmat(b1,1,Q) + IW1_1*xp1);

% Layer 2
a2 = tansig_apply(repmat(b2,1,Q) + LW2_1*a1);

% Output 1
y1 = mapminmax_reverse(a2,y1_step1);
end

% ===== MODULE FUNCTIONS ========

% Map Minimum and Maximum Input Processing Function
function y = mapminmax_apply(x,settings)
  y = bsxfun(@minus,x,settings.xoffset);
  y = bsxfun(@times,y,settings.gain);
  y = bsxfun(@plus,y,settings.ymin);
end

% Sigmoid Symmetric Transfer Function
function a = tansig_apply(n,~)
  a = 2 ./ (1 + exp(-2*n)) - 1;
end

% Map Minimum and Maximum Output Reverse-Processing Function
function x = mapminmax_reverse(y,settings)
  x = bsxfun(@minus,y,settings.ymin);
  x = bsxfun(@rdivide,x,settings.gain);
  x = bsxfun(@plus,x,settings.xoffset);
end
